/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.util;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;

import javax.swing.JDialog;
import javax.swing.JInternalFrame;

import com.sonicsw.ma.gui.JPreferencesDialog;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;

public class SizeHelper implements ISizeHelper
{
    private static final String WINDOW_PREF   = "window";
    private static final String WINDOW_WIDTH  = "width";
    private static final String WINDOW_HEIGHT = "height";
    private static final String WINDOW_MAX    = "max";
    private static final String WINDOW_X      = "x";
    private static final String WINDOW_Y      = "y";

    /**
     * Method to restore the persisted window size User Preference setting.
     *
     * @return Flag indicating whether the setting was restored
     */
    public static boolean restoreWindowSize(Container container)
    {
        boolean restored = false;

        if (isResizable(container))
        {
            PreferenceManager prefMgr = PreferenceManager.getInstance();

            // Check to see if the User Preference for persisting the Window Sizes
            // is set.  If so, restore the Window Size setting.
            if (prefMgr.getBoolean(JPreferencesDialog.GENERAL_PREFS,
                                   JPreferencesDialog.SAVE_WINDOW_SIZES,
                                   true))
            {
                String prefPath = WINDOW_PREF + "." + getName(container);

                int width  = prefMgr.getInt(prefPath, WINDOW_WIDTH,  -1);
                int height = prefMgr.getInt(prefPath, WINDOW_HEIGHT, -1);

                if (width != -1 && height != -1)
                {
                    restored = true;
                    container.setSize(width, height);
                }
            }
        }
        return (restored);
    }

    /**
     * Method to restore the persisted window position User Preference setting.
     *
     * @return Flag indicating whether the setting was restored
     */
    public static boolean restoreWindowPosition(Container container)
    {
        boolean restored = false;

        PreferenceManager prefMgr = PreferenceManager.getInstance();

        // Check to see if the User Preference for persisting the Window Positions
        // is set.  If so, restore the Window Position setting.
        if (prefMgr.getBoolean(JPreferencesDialog.GENERAL_PREFS,
                               JPreferencesDialog.SAVE_WINDOW_POSITIONS,
                               true))
        {
            String prefPath = WINDOW_PREF + "." + getName(container);

            int x = prefMgr.getInt(prefPath, WINDOW_X, -1);
            int y = prefMgr.getInt(prefPath, WINDOW_Y, -1);

            if (x != -1 && y != -1)
            {
                restored = true;
                container.setLocation(x, y);

                if(container instanceof JInternalFrame)
                {
                    if(prefMgr.getBoolean(prefPath, WINDOW_MAX, false))
                    {
                        try
                        {
                            ((JInternalFrame)container).setMaximum(true);
                        }
                        catch(Exception e)
                        {
                            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
                        }
                    }
                }
            }
        }
        return (restored);
    }

    /**
     * Method to save the window size User Preference setting.
     */
    public static void saveWindowSize(Container container)
    {
        PreferenceManager prefMgr = PreferenceManager.getInstance();

        if (isResizable(container))
        {
            // Check to see if the User Preference for persisting the Window Sizes
            // is set.  If so, save the Window Size setting.
            if (prefMgr.getBoolean(JPreferencesDialog.GENERAL_PREFS,
                                   JPreferencesDialog.SAVE_WINDOW_SIZES,
                                   true))
            {
                String prefPath = WINDOW_PREF + "." + getName(container);

                int width = container.getWidth();
                int height = container.getHeight();

                if(container instanceof JMAInternalFrame)
                {
                    boolean max = ((JInternalFrame)container).isMaximum();

                    if(max)
                    {
                        Rectangle rect = ((JMAInternalFrame)container).getRestoreBounds();
                        width  = rect.width;
                        height = rect.height;
                    }
                }

                prefMgr.setInt(prefPath, WINDOW_WIDTH,  width,  false);
                prefMgr.setInt(prefPath, WINDOW_HEIGHT, height, false);

                // we aren't doing the flush since we assume that save
                // window position is always done next
            }
        }
    }

    /**
     * Method to save the window position User Preference setting.
     */
    public static void saveWindowPosition(Container container)
    {
        PreferenceManager prefMgr = PreferenceManager.getInstance();

        // Check to see if the User Preference for persisting the Window Positions
        // is set.  If so, save the Window Position setting.
        if (prefMgr.getBoolean(JPreferencesDialog.GENERAL_PREFS,
                               JPreferencesDialog.SAVE_WINDOW_POSITIONS,
                               true))
        {
            String prefPath = WINDOW_PREF + "." + getName(container);

            Point pt = container.getLocation();

            if(container instanceof JMAInternalFrame)
            {
                boolean max = ((JInternalFrame)container).isMaximum();

                prefMgr.setBoolean(prefPath, WINDOW_MAX, max, false);

                if(max)
                {
                    Rectangle rect = ((JMAInternalFrame)container).getRestoreBounds();

                    pt.x = rect.x;
                    pt.y = rect.y;
                }
            }

            prefMgr.setInt(prefPath, WINDOW_X, pt.x, false);
            prefMgr.setInt(prefPath, WINDOW_Y, pt.y, true);
        }
    }

    private static String getName(Container container)
    {
        String name  = null;
        String title = null;

        if(container instanceof JMADialog)
        {
            name  = ((JMADialog)container).getTitleKey();
            title = ((JMADialog)container).getTitle();
        }
        else if(container instanceof JMAInternalFrame)
        {
            name  = ((JMAInternalFrame)container).getTitleKey();
            title = ((JMAInternalFrame)container).getTitle();
        }
        else if(container instanceof JMAFrame)
        {
            name  = ((JMAFrame)container).getTitleKey();
            title = ((JMAFrame)container).getTitle();
        }

        if(name == null)
        {
            name = container.getClass().getName();
        }

        if(title != null && title.length() > 0)
        {
            return name + "." + title.replace('/', '#');
        }

        return name;
    }

    private static boolean isResizable(Container container)
    {
        if(container instanceof JDialog)
        {
            return ((JDialog)container).isResizable();
        }

        return true;
    }
}