package com.sonicsw.ma.gui.util;

import java.awt.Color;
import java.util.Map;

import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.common.runtime.ISubComponentState;
import com.sonicsw.mf.common.runtime.Level;

public class StateHelper
{
    public static final short STATE_COMBINED = (short)(IComponentState.STATE_STOPPING + 2);

    private StateHelper()
    {
    }

    public static final String getComponentStateText(short state)
    {
        if(state == STATE_COMBINED)
        {
            return "Combined";
        }

        return IComponentState.STATE_TEXT[state];
    }

    public static final Color componentStateToColor(IState state)
    {
        short sValue = IComponentState.STATE_UNKNOWN;

        if (state != null)
        {
            if (state instanceof IContainerState)
            {
                IComponentState[] children = ((IContainerState)state).getComponentStates();


                if (children.length > 0)
                {
                    sValue = getCombinedState(children);
                }
                else
                {
                    sValue = state.getState();
                }
            }
            else{
                sValue = getSubComponentState(state);
            }
        }

        return componentStateToColor(sValue);
    }

    public static final short getCombinedState(IState[] states)
    {
        int online    = 0;
        int offline   = 0;
        int unknown   = 0;
        int startstop = 0;

        for(int i = 0; i < states.length; i++)
        {
            switch (states[i].getState())
            {
                case IComponentState.STATE_ONLINE:   online++; break;
                case IComponentState.STATE_OFFLINE:  offline++; break;
                case IComponentState.STATE_UNKNOWN:  unknown++; break;
                case IComponentState.STATE_STARTING: startstop++; break;
                case IComponentState.STATE_STOPPING: startstop++; break;
            }
        }


        if(startstop == states.length){
            return IComponentState.STATE_STARTING;
        }else{
            if(online == states.length){
                return getSubComponentState(states,IComponentState.STATE_ONLINE);
            }
            if(offline == states.length)
            {
                return IComponentState.STATE_OFFLINE;
            }
            if(unknown == states.length)
            {
                return IComponentState.STATE_UNKNOWN;
            }
        }
        return STATE_COMBINED;
    }

    public static final short getSubComponentState(IState state) {
        IState[] states = {state};
        return getSubComponentState(states,state.getState());
    }
    public static final short getSubComponentState(IState[] states, short parentState) {
        if (parentState == IComponentState.STATE_OFFLINE)
        {
            return parentState;
        }
        for (int i = 0; i < states.length; i++)
        {
            if (states[i] instanceof IComponentState)
            {
                Map<String, ISubComponentState[]> subCompStates = ((IComponentState) states[i]).getSubComponentStates();
                if(subCompStates != null)
                {
                    for (Map.Entry<String, ISubComponentState[]> entry : subCompStates.entrySet())
                    {
                    ISubComponentState[] subCompStatesEntry = entry.getValue();
                        if (subCompStatesEntry != null && subCompStatesEntry.length > 0)
                        {
                            for (int j = 0; j < subCompStatesEntry.length; j++)
                            {
                                if (subCompStatesEntry[j].getState() != IComponentState.STATE_ONLINE)
                                {
                                    return STATE_COMBINED;
                                }
                            }
                        }
                    }
                }else
                {
                    return parentState;
                                }
                            }
            else if (states[i] instanceof IState)
            {
                return parentState;
            }
        }
        return parentState;
    }


    public static final Color componentStateToColor(short state)
    {
        Color color = Color.BLUE;   // UNKNOWN

        switch (state)
        {
            case IComponentState.STATE_OFFLINE  : color = Color.RED;   break;
            case IComponentState.STATE_ONLINE   : color = Color.GREEN; break;
            case IComponentState.STATE_STARTING : color = Color.CYAN;  break;
            case IComponentState.STATE_STOPPING : color = Color.CYAN;  break;
            case STATE_COMBINED                 : color = Color.YELLOW; break;
        }
        return color;
    }

    public static final Color errorLevelToColor(int level)
    {
        Color color = Color.BLUE; // UNKNOWN

        switch (level)
        {
            case Level.FINEST  : color = Color.BLACK;   break;
            case Level.FINER   : color = Color.CYAN;    break;
            case Level.FINE    : color = Color.WHITE;   break;
            case Level.CONFIG  : color = Color.GREEN;   break;
            case Level.INFO    : color = Color.YELLOW;  break;
            case Level.WARNING : color = Color.ORANGE;  break;
            case Level.SEVERE  : color = Color.RED;     break;
        }
        return color;
    }
}

