package com.sonicsw.ma.gui.util;

import java.awt.Window;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.DSFileChooser;
import com.sonicsw.ma.gui.config.FileElementFilter;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;

import com.sonicsw.mf.common.config.IMFDirectories;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.FromFolder;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mx.config.IdentityOnlyConfigBean;

/**
 * @author <a href="mailto:murali@sonicsoftware.com">Murali Mohan</a>
 * @since: Sep 26, 2006
 */
public class Utils {

    // The following constants are duplicates of those found in InterPluginValidation
    public final static String USER_LOCATION_SUFFIX = IMFDirectories.MF_DIR_SEPARATOR + IMFDirectories.MF_USERS_DIR + IMFDirectories.MF_DIR_SEPARATOR;
    public final static String EXTERNAL_USER_LOCATION_SUFFIX = IMFDirectories.MF_DIR_SEPARATOR + "external" + USER_LOCATION_SUFFIX;

    public final static String GROUP_LOCATION_SUFFIX = IMFDirectories.MF_DIR_SEPARATOR + IMFDirectories.MF_GROUPS_DIR + IMFDirectories.MF_DIR_SEPARATOR;
    public final static String EXTERNAL_GROUP_LOCATION_SUFFIX = IMFDirectories.MF_DIR_SEPARATOR + "external" + GROUP_LOCATION_SUFFIX;

    public static String chooseFile(Window parentDialog, IPlugin plugin, String[] filters){
        FileElementFilter filter = new FileElementFilter();
        filter.setSelectedFilter(filters[0]);
        IPluginContext pluginContext = plugin.getPluginContext();
        IConfigServer server = pluginContext.getConnectionInfo().getConfigServer();
        JPropSheetDialog dialog = null;
        if(parentDialog instanceof JPropSheetDialog){
         dialog = new DSFileChooser((JPropSheetDialog) parentDialog,
                    "file.choose",
                    pluginContext,
                    server,
                    filter,
                    filters,
                    false);
        }else if(parentDialog instanceof JMAFrame){
            dialog = new DSFileChooser((JMAFrame)parentDialog,
                    "file.choose",
                    pluginContext,
                    server,
                    filter,
                    filters,
                    false);
        }
        try {
            if (dialog != null)
            {
                dialog.editInstance(plugin, new HashMap(), false);
                dialog.setVisible(true);
                if (dialog.getCloseCommand() == JMADialog.CLOSE_OK)
                {
                    HashMap selList = (HashMap)dialog.getModel();
                    if ((selList != null) && !selList.isEmpty())
                    {
                        return "sonicfs://" + selList.keySet().iterator().next();
                    }
                }
            }
            else
            {
                MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, "Unable to create dialog.", true);
            }
        }
        catch (Exception e1) {
            MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, "Failed to choose file.", e1, true);
        }
        return null;
    }

    public static Set getDomainUsers(String domain,IConfigServer server) {
        return getDomainUsers(domain,server,false);
    }


    public static Set getDomainUsers(String domain,IConfigServer server,boolean includeExternal) {
        try {
            if(domain ==null)
            {
                return Collections.EMPTY_SET;
            }
            String usersDir = domain + USER_LOCATION_SUFFIX;

            From fromUsersDir = new FromFolder(usersDir);
            Query getUsersQuery = new Query();
            getUsersQuery.setFrom(fromUsersDir);

            Set internalUsers = server.loadConfigElements(getUsersQuery);
            if(!includeExternal)
            {
                return internalUsers;
            }
            String externalUsersDir = domain + EXTERNAL_USER_LOCATION_SUFFIX;
            try {
                fromUsersDir = new FromFolder(externalUsersDir);
                getUsersQuery.setFrom(fromUsersDir);
                Set externalUsers = server.loadConfigElements(getUsersQuery);
                internalUsers.addAll(externalUsers);
            }
            catch (Exception e1) {
                // ignore.  We will get an exception if there are no external users in the domain.
                // there's always internal users
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e1.getMessage(), e1, false);    // Log the error msg.
            }
            return internalUsers;
        }
        catch (Exception e1) {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR, "Could not get a principal list", e1, true);
        }
        return Collections.EMPTY_SET;
    }

    public static Set getDomainGroups(String domain,IConfigServer server) {
        return getDomainGroups(domain,server,false);

    }

    public static Set getDomainGroups(String domain,IConfigServer server,boolean includeExternal) {
        try {
            if (domain == null)
            {
                return Collections.EMPTY_SET;
            }
            String groupsDir = domain + GROUP_LOCATION_SUFFIX;

            From fromGroupsDir = new FromFolder(groupsDir);
            Query getGroupsQuery = new Query();
            getGroupsQuery.setFrom(fromGroupsDir);

            Set internalGroups = server.loadConfigElements(getGroupsQuery);
            if(!includeExternal)
            {
                return internalGroups;
            }

            fromGroupsDir = new FromFolder(domain + EXTERNAL_GROUP_LOCATION_SUFFIX);
            getGroupsQuery.setFrom(fromGroupsDir);

            try {
                Set externalGroups = server.loadConfigElements(getGroupsQuery);
                internalGroups.addAll(externalGroups);
            }
            catch (Exception e) {
                // ignore.  We will get an exception if there are no external groups in the domain.
                // there's always internal groups
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
            }
            return internalGroups;
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR, "Could not get a principal list", e, true);
        }
        return Collections.EMPTY_SET;
    }

    public static String getDefaultAuthenticationDomainDir(IConfigServer server) {
        try {
            Query query = new Query().setFrom(new FromElementType("MF_AUTHENTICATION_DOMAIN"));
            Set elements = server.loadConfigElements(query);
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                IConfigBean bean = (IConfigBean) i.next();
                String path = bean.getName();

                if (path.endsWith(ConfigServerUtility.DEFAULT_SUFFIX) ||
                        path.endsWith(ConfigServerUtility.DOMAIN_DESCRIPTOR_SUFFIX) ||
                        path.endsWith(ConfigServerUtility.POLICY_DESCRIPTOR_SUFFIX)) {
                    int lastIndex = path.lastIndexOf('/');

                    path = path.substring(0, lastIndex);
                }
                if (!(bean instanceof IConfigPrototype)) {//ignore template
                    return path;
                }
            }
        }
        catch (Exception e) {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
        return null;
    }

    public static String getConfigBeanIdentifierName(IConfigBean iConfigBean) {

        String ret = iConfigBean.toString();

        if (!IdentityOnlyConfigBean.isUnidentifiable(iConfigBean))
        {
            ret = iConfigBean.getName();
        }

        if (ret != null && ret.endsWith(ConfigServerUtility.DEFAULT_SUFFIX))
        {
            int index = ret.lastIndexOf('/');
            ret = ret.substring(0, index);
        }

        return ret;
    }

}
