package com.sonicsw.ma.gui.util;

import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;


public class ValidNameFromTextFieldConverter implements ViewValueConverter
{
    private int m_type;

    public ValidNameFromTextFieldConverter()
    {
    }

    public ValidNameFromTextFieldConverter(int type)
    {
        m_type = type;
    }

    @Override
    public Object viewValueToModel(Object viewValue)
       throws ViewValueConversionException
    {
        // We have to return an empty string here rather than null because
        // ModelObjects won't see "null" as a change from the previous un-set
        // value and so won't create a change event.
        if ((viewValue == null) || (viewValue.equals("")))
        {
            return "";
        }

        if (viewValue instanceof String)
        {
            try
            {
                ValidName.validate((String)viewValue, m_type);
                return viewValue;
            }
            catch (Exception e)
            {
                throw new ViewValueConversionException(e.getMessage(), e);
            }
        }

        throw new ViewValueConversionException("expected a string");
    }

    @Override
    public Object modelValueToView(Object modelValue)
       throws ViewValueConversionException
    {
        // Whatever the value is, just return
        return modelValue;
    }

    @Override
    public String[] getViewStringValues()
    {
        return null;
    }

    @Override
    public boolean isViewValueToModelSupported()
    {
        return true;
    }

    @Override
    public Class getModelClass()
    {
        return String.class;
    }

    @Override
    public Class getViewClass()
    {
        return String.class;
    }
}