package com.sonicsw.ma.mgmtapi.config.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtAttributeMetaData;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mx.config.IAttributeMetaData;

public class MgmtAttributeMetaData implements IMgmtAttributeMetaData
{
    private IAttributeMetaData m_data;

    public MgmtAttributeMetaData(IAttributeMetaData data)
    {
        m_data = data;
    }

    @Override
    public boolean isFromTemplate() throws MgmtException
    {
        if (m_data == null)
        {
            throw new MgmtException("No metadata for attribute");
        }

        return m_data.isFromPrototype();
    }

    @Override
    public boolean isFromType() throws MgmtException
    {
        if (m_data == null)
        {
            throw new MgmtException("No metadata for attribute");
        }

        return m_data.isFromConfigType();
    }

    @Override
    public boolean isFromBean() throws MgmtException
    {
        if (m_data == null)
        {
            throw new MgmtException("No metadata for attribute");
        }

        return m_data.isFromConfigBean();
    }
}