package com.sonicsw.ma.mgmtapi.config.impl;

import java.util.ArrayList;
import java.util.List;

import com.sonicsw.ma.mgmtapi.config.IMgmtBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.IMgmtMapBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;

public class MgmtMapBase extends MgmtSubBeanBase implements IMgmtMapBase
{
    public MgmtMapBase(IMgmtBase parent, String name, boolean isNew)
        throws MgmtException
    {
        super(parent, name, isNew);
    }

    @Override
    public List getKeyNames()
        throws MgmtException
    {
        try
        {
            return new ArrayList(getRealAttributeMap().keySet());
        }
        catch(Throwable e)
        {
            throw new MgmtException("Failed to getKeyNames for " + m_name +
                                    " - " + e.getMessage(), e);
        }
    }

    @Override
    public void add(String name, Object val)
        throws MgmtException
    {
        try
        {
            IAttributeMap map = getRealAttributeMap();

            if(val instanceof IMgmtBeanBase)
            {
                map.put(name, ((IMgmtBeanBase)val).getConfigBean());
            }
            else if(val instanceof IMgmtBase)
            {
                map.put(name, ((IMgmtBase)val).getAttributeMap());
            }
            else
            {
                map.put(name, val);
            }

            // Sonic00015180 - when adding a sub-bean, i.e. we have to fetch
            // the set attribute back from the ConfigLayer because it does a
            // clone on 'val'...otherwise subsequent sets on 'val' will float
            // and never get persisted.
            //
            if (val instanceof MgmtSubBeanBase)
            {
                Object newVal = map.get(name);

                if (newVal instanceof IAttributeMap)
                {
                    ((MgmtSubBeanBase)val).m_map = (IAttributeMap)newVal;
                }
                else
                if (newVal instanceof IAttributeList)
                {
                    ((MgmtSubBeanBase)val).m_list = (IAttributeList)newVal;
                }
            }
        }
        catch(Throwable e)
        {
            throw new MgmtException("Failed to add " + name + " - " +
                                    e.getMessage(), e);
        }
    }

    @Override
    public void delete(String name)
        throws MgmtException
    {
        try
        {
            IAttributeMap map = getRealAttributeMap();

            map.removeAttribute(name);
        }
        catch(Exception e)
        {
            throw new MgmtException("Failed to delete " + name + " - " +
                                    e.getMessage(), e);
        }
    }
}