package com.sonicsw.ma.mgmtapi.util;

// originally copied from com.sonicsw.ma.gui.util.ValidName

public class ValidName
{

    private static final String[] group_0  = new String[] { ".","*","#","$" };                       //CLIENTID_TYPE, CONNECTID_TYPE
    private static final String[] group_1  = new String[] { ".","*","#","$","\\" };                  //CLUSTER_TYPE, DURABLESUBSCRIPTION_TYPE, GROUP_TYPE
    private static final String[] group_2  = new String[] { ".","*","#","$","\\","\"", "::", ":" };  //COLLECTION_TYPE, CONTAINER_TYPE, COMPONENT_TYPE
    private static final String[] group_3  = new String[] { "*","#","$","\\","\"","::" };         //ROUTINGNODE_TYPE
    private static final String[] group_4  = new String[] { "*","#","$","\\" };                      //ROUTINGUSER_TYPE. USER_TYPE
    private static final String[] group_5  = new String[] { "*","#","$","\\","::" };             //QUEUE_TYPE
    private static final String[] group_6a = new String[] { "*","#","$","\\","::",":" };                  //TOPIC_TYPE
    private static final String[] group_6b = new String[] { "$","\\","::",":" };                  //RELAXED TOPIC_TYPE (FOR GLOBAL SUBSCRIPTIONS)
    private static final String[] group_7  = new String[] { "?","|","<",">","/", "=", "," };         //Special to WIN_32 names restriction and JMX


    public static final int CLIENTID_TYPE                 = 0;
    public static final int CLUSTER_TYPE                  = 1;
    public static final int COLLECTION_TYPE               = 2;
    public static final int COMPONENT_TYPE                = 3;
    public static final int CONNECTID_TYPE                = 4;
    public static final int CONTAINER_TYPE                = 5;
    public static final int DURABLESUBSCRIPTION_TYPE      = 6;
    public static final int GROUP_TYPE                    = 7;
    public static final int QUEUE_TYPE                    = 8;
    public static final int ROUTINGNODE_TYPE              = 9;
    public static final int ROUTINGUSER_TYPE              = 10;
    public static final int TOPIC_TYPE                    = 11;
    public static final int RELAXED_TOPIC_TYPE            = 12;
    public static final int USER_TYPE                     = 13;


    public static void validate(String name, int type)
    throws Exception
    {
       switch (type)
       {
            case CLIENTID_TYPE :
            case CONNECTID_TYPE :
                validateRestrictions(name, group_0);
                break;
            case CLUSTER_TYPE :
            case GROUP_TYPE :
            case DURABLESUBSCRIPTION_TYPE:
                validateRestrictions(name, group_1);
                break;
            case COLLECTION_TYPE :
            case CONTAINER_TYPE :
            case COMPONENT_TYPE :
                validateRestrictions(name, group_2);
                validateRestrictions(name, group_7);
                break;
            case ROUTINGNODE_TYPE :
                validateRestrictions(name, group_3);
                break;
            case ROUTINGUSER_TYPE :
            case USER_TYPE:
                validateRestrictions(name, group_4);
                break;
            case QUEUE_TYPE :
                validateRestrictions(name, group_5);
                break;
            case TOPIC_TYPE :
                validateRestrictions(name, group_6a);
                break;
            case RELAXED_TOPIC_TYPE :
                validateRestrictions(name, group_6b);
                break;
        }
    }

    private static void validateRestrictions( String name, String[] group)
    throws Exception
    {
        for (int i = 0; i < group.length; i++)
        {
            int index = name.indexOf(group[i]);
            if(index != -1)
            {
                throw new Exception("Name contains invalid character:  " + group[i] + " ");
            }
        }
    }
}