/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.util.ConfigHelper;

public abstract class AbstractExtensionFactory implements IContainerExtensionFactory
{
    @Override
    public abstract String getId();
    @Override
    public String getDescription() { return getId(); }
    @Override
    public abstract String getConfigType();
    @Override
    public abstract String getConfigVersion();
    public abstract String getProductVersion();
    
    @Override
    public abstract JConfigDialog getPropertySheet(JConfigDialog parent, IPluginContext context)
    throws Exception;
    
    @Override
    public boolean isComponentDependent(String type, String productVersion, String configVersion)
    {
        return false;
    }

    protected String getPath(IConfigBean containerBean)
    {
//        int endPath = containerBean.getName().lastIndexOf(ConfigServerUtility.DEFAULT_SUFFIX);
//        return containerBean.getName().substring(0, endPath) + "Extensions";
        return "/System/Container Extensions/" + containerBean.getName().substring(containerBean.getName().lastIndexOf("/")+1);
    }
    
    /**
     * Provide any additional configuration to a newly created model.
     * e.g. set any required (mandatory) attributes.
     * 
     * @param bean
     * @throws ConfigServiceException
     */
    @Override
    public void modelCreated(IConfigBean createdBean)
    throws ConfigServiceException
    {
    }
    
    /**
     * Called after the extension is copied to allow any extension
     * specific setup of the copy.
     */
    @Override
    public void modelCopied(IConfigBean copiedBean)
    throws ConfigServiceException
    {
    }

    @Override
    public IConfigBean createModel(IConfigBean containerBean)
    throws ConfigServiceException
    {
        IConfigServer server = containerBean.getConfigServer();
        String fPath = getPath(containerBean);
        String path = fPath + "/" + getId();

        containerBean.getConfigServer().createFolder(fPath, null, true);

        System.out.println("creating extension model " + getConfigType() + ", v" + getConfigVersion() + " in '" + path + "'");

        boolean isTemplate = (containerBean instanceof IConfigPrototype);
        IConfigBean bean = ConfigHelper.createBean(server, path, getConfigType(), getConfigVersion(), getProductVersion(), isTemplate);
    
        modelCreated(bean);
        
        return bean;
    }

    @Override
    public String toString()
    {
        return getClass().getName() + " [" + getId() + ", " + getDescription() + ", " + getConfigType() + ", " + getConfigVersion() + "]";
    }
}
