/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.plugin;

import java.awt.Component;
import java.awt.Font;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.Helper;

public abstract class AbstractPluginTreeCellRenderer extends DefaultTreeCellRenderer
{
    private int  m_gray        = 0;
    private Font highlightFont = null;

    @Override
    public Component getTreeCellRendererComponent(JTree   tree,
                                                  Object  value,
                                                  boolean selected,
                                                  boolean expanded,
                                                  boolean isLeaf,
                                                  int     rowNum,
                                                  boolean hasFocus)
    {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, rowNum, hasFocus);

        setGrayIcon(0);

        if (highlightFont == null)
        {
            highlightFont = tree.getFont().deriveFont(Font.ITALIC | Font.BOLD);
        }

        // A neat hack to make the selection color depend on whether the tree
        // currently has the focus...
        if (!tree.isFocusOwner())
        {
            // This next line is needed to handle popup menus which grab the focus!
            //&& (tree instanceof JPluginTree) && !((JPluginTree)tree).isFocusLossTemporary())
            setBackgroundSelectionColor(UIManager.getColor("ComboBox.disabledBackground"));
            setForeground(getTextNonSelectionColor());
        }
        else
        {
            setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        }

        // Make sure that the font used is the tree's default font...
        setFont(tree.getFont());

        // set the default icons...
        setIcon(UIManager.getIcon(expanded ? "Tree.openIcon" : "Tree.closedIcon"));

        // Check to see that the tree node is derived from AbstractPluginTreeNode
        if (value instanceof AbstractGUIPlugin)
        {
            AbstractGUIPlugin node = (AbstractGUIPlugin)value;

            updateRenderer(this, node);

            // Only gray the icon if the plugin on the clipboard has been cut...
            //
            if (MgmtConsole.getMgmtConsole().getClipboardAction() == MgmtConsole.CLIP_ACTION_CUT)
            {
                Object clipboardObject = MgmtConsole.getMgmtConsole().getClipboardObject();

                if ((clipboardObject != null) && clipboardObject.equals(value))
                {
                    setGrayIcon(40);
                }
            }
        }
        else
        {
            setIcon(null);
            setText("Loading...");
        }

        return this;
    }

    public void highlight(boolean state)
    {
        if (state)
        {
            setFont(highlightFont);
        }
    }

    public void setGrayIcon(int percentage)
    {
        m_gray = percentage;
    }

    @Override
    public Icon getIcon()
    {
        Icon icon = super.getIcon();

        if (m_gray > 0)
        {
            icon = Helper.createDisabledIcon(icon, m_gray);
        }

        return icon;
    }

    /**
     * Subclasses must implement this method which will set the appropriate
     * text and icon on the label (cell renderer) for the given tree node.
     *
     * @param label  The cell renderer to be configured
     * @param node   The AbstractPluginTreeNode (data) that is being renderered
     */
    public abstract void updateRenderer(JLabel label, AbstractGUIPlugin plugin);
}
