/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.plugin;

import java.io.File;
import java.io.IOException;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.util.FileTracker;
import com.sonicsw.ma.util.FileTrackerHandler;

/**
 * <p>Title: CommandLineToolInfo</p>
 * <p>Description: Creates a TooInfo for external command-line applications.</p>
 * <p>Copyright: Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.</p>
 * <p>Company: Sonic Software Corporation</p>
 * @author Jeffrey S. Pace
 * @version 1.0
 */
public class CommandLineToolInfo extends ToolInfo
{
    protected String m_commandLine;
    protected File m_fileArgument;

    /**
     * Creates a CommandLineToolInfo
     * @param name
     * @param description
     * @param commandLine
     */
    public CommandLineToolInfo(String name, String description, String commandLine, File fileArgument)
    {
        this(null, name, description, commandLine, fileArgument, false);
    }

    /**
     * Creates a CommandLineToolInfo
     * @param context
     * @param name
     * @param description
     * @param commandLine
     * @param configure
     */
    public CommandLineToolInfo(IPluginContext context, String name, String description,
                               String commandLine, File fileArgument, boolean configure)
    {
        m_commandLine = commandLine;
        m_fileArgument = fileArgument;

        commonInit(context, name, description, configure);
    }

    protected CommandLineToolInfo() {}

    /**
     * Determines when this tool can be enabled.
     * @return boolean
     */
    @Override
    public boolean canEnable()
    {
        return true;
    }

    /**
     * Execution of the Tool.
     */
    @Override
    public void execute()
    {
        execute(null);
    }

    public void execute(final FileTrackerHandler handler)
    {
        Thread t = new Thread(new Runnable()
        {
            @Override
            public void run()
            {
                try
                {
                    if ((m_fileArgument != null) && (handler != null))
                    {
                        FileTracker.add(handler);
                    }

                    Process p = Runtime.getRuntime().exec(createCommand());

                    int exitCode = p.waitFor();

                    if ((m_fileArgument != null) && (handler != null))
                    {
                        FileTracker.remove(handler);
                    }

                    if (handler != null)
                    {
                        handler.fileFinished(exitCode);
                    }
                }
                catch (Exception e)
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                                         "Failed to launch tool " + m_commandLine, e, true);
                }
            }
        });

        t.start();
    }

    protected String createCommand()
        throws IOException
    {
        StringBuffer sb = new StringBuffer(m_commandLine);

        if (m_fileArgument != null)
        {
            if (m_fileArgument.exists())
            {
                sb.append(" ");
                sb.append(m_fileArgument.getAbsolutePath());
            }
            else
            {
                throw new IOException("Could not find file [" + m_fileArgument.getAbsolutePath() + "]");
            }
        }
        return sb.toString();
    }
}