/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.plugin;

import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigPrototype;

/**
 * This wrapper class is used to package the underlying Config Layer element
 * along with any other related information such as view name, etc.
 */
public class ConfigBeanModel
{
    public static final IConfigPath NAME = ConfigFactory.createConfigPath("_VIEW_NAME");

    private IAttributeList        m_configDataList;
    private IAttributeMap         m_configData;
    private IAttributeDescription m_configType;
    private String                m_viewName;

    public ConfigBeanModel(IConfigBean configData)
    {
        setConfigBeanModelData(configData);
        
        String path = configData.getName();
        if (path.endsWith(ConfigServerUtility.DOMAIN_DESCRIPTOR_SUFFIX) ||
            path.endsWith(ConfigServerUtility.POLICY_DESCRIPTOR_SUFFIX) ||
            path.endsWith(ConfigServerUtility.DEFAULT_SUFFIX))
        {
            path = path.substring(0, path.lastIndexOf('/'));
        }

        setViewName(path.substring(path.lastIndexOf('/') + 1));
    }

    private void setConfigBeanModelData(IConfigBean configData) {
        setData(configData);
        setType(null);
    }
    
    public ConfigBeanModel(IConfigBean configData,
                           String      viewName)
    {
        this(configData, null, viewName);
    }

    public ConfigBeanModel(IAttributeMap         configData,
                           IAttributeDescription configType,
                           String                viewName)
    {
        setConfigBeanModelObj(configData, configType);
        setViewName(viewName);
    }

    public ConfigBeanModel(IAttributeList        configData,
                           IAttributeDescription configType,
                           String                viewName)
    {
        setConfigBeanModelObj(configData, configType);
        setViewName(viewName);
    }

    private void setConfigBeanModelObj(IAttributeMap         configData,
                                       IAttributeDescription configType) {
        setData(configData);
        setType(configType);
    }
    
    private void setConfigBeanModelObj(IAttributeList        configData,
                                       IAttributeDescription configType) {
        setData(configData);
        setType(configType);
    }
    
    public IAttributeMap getData()
    {
        return m_configData;
    }

    public IAttributeList getDataList()
    {
        return m_configDataList;
    }

    /**
     * There should be no situation when we might want to externally change
     * the data.
     *
     * @param configData
     */
    protected void setData(IAttributeMap configData)
    {
        m_configData     = configData;
        m_configDataList = null;
    }

    protected final void setData(IAttributeList configData)
    {
        m_configData     = null;
        m_configDataList = configData;
    }

    public String getViewName()
    {
        return m_viewName;
    }

    public final void setViewName(String viewName)
    {
        m_viewName = viewName;
    }

    public String getConfigName()
    {
        if (getData() instanceof IConfigBean)
        {
            return ((IConfigBean)getData()).getName();
        }

        return null;
    }

    public IAttributeDescription getType()
    {
        IAttributeDescription res = m_configType;

        if (m_configData instanceof IConfigBean)
        {
            res = ((IConfigBean)m_configData).getConfigType();
        }

        return res;
    }

    public boolean isTemplateInstance()
    {
        boolean res = false;

        if (getData() != null)
        {
            if (getData() instanceof IConfigBean)
            {
                res = ((IConfigBean)getData()).isPrototypeInstance();
            }
            else
            if (getData() instanceof com.sonicsw.mx.config.impl.AttributeMapImpl)
            {
                IConfigElement owner = ((com.sonicsw.mx.config.impl.AttributeMapImpl)getData()).getOwner();

                res = ((owner != null) && owner.isPrototypeInstance());
            }
        }

        return res;
    }

    public boolean isTemplate()
    {
        return (getData() instanceof IConfigPrototype);
    }

    /**
     * There should be no situation when we might want to externally change
     * the type associated with the data.
     *
     * @param configType
     */
    protected void setType(IAttributeDescription configType)
    {
        m_configType = (getData() instanceof IConfigBean) ? null : configType;
    }
}
