package com.sonicsw.ma.plugin;

import com.sonicsw.mx.config.IConfigServer;

public class ConfigContext implements IConfigContext
{
    private IPluginContext m_context;

    public ConfigContext(IPluginContext parent) throws Exception
    {
        m_context = parent;
    }

    /**
     * Get the ConfigManager which is used to store/retrieve ConfigBeans
     * form the Directory Service
     */
    @Override
    public IConfigServer getConfigServer()
    {
        return m_context.getConnectionInfo().getConfigServer();
    }

    /**
     * Get the Plugin Factory
     */
    @Override
    public IConfigPluginFactory getPluginFactory(String type, String cVersion, String pVersion)
    {
        return m_context.getLibrary().getChildConfigPluginFactory(type, cVersion, pVersion);
    }
}