/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.plugin;

import java.awt.Window;

import javax.swing.JFrame;

public class DefaultAnnotationProvider implements IAnnotationProvider
{
    @Override
    public boolean isAnnotationSupported(String type, String cVersion, String pVersion)
    {
    	return (type != null);  // null = folder :)
    }

    @Override
    public String openAnnotationEditor(String type, String cVersion, String pVersion, String data, Window parent)
    {    	
    	
    	JFrame frame = new JFrame();
		DefaultAnnotationProviderJDialog inst = new DefaultAnnotationProviderJDialog(frame, data);
		inst.setModal(true);
		inst.setVisible(true);
    	
		//System.out.println("Returned from dialog");
		
		if (!inst.exitedOnOk())
        {
            return data;
        }
		
		String newAnnotation = inst.getText();
		
		if (null == newAnnotation)
        {
            return null;
        }
		
		if (newAnnotation.equals(data))
        {
            return data;
        }
				
    	return newAnnotation;
    }
}
