package com.sonicsw.ma.plugin;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;


public class DefaultAnnotationProviderJDialog extends JDialog {

	private static final long serialVersionUID = 1L;
	
	protected JButton btnCancel;
	protected JButton btnOk;
	protected DefaultAnnotationProviderJPanel annotationPanel;

	protected boolean exitedOnOk = false;
	
	

	public static void main(String[] args) {
		JFrame frame = new JFrame();
		DefaultAnnotationProviderJDialog inst = new DefaultAnnotationProviderJDialog(frame, "Initial annotation");
		inst.setVisible(true);
	}
	
	public DefaultAnnotationProviderJDialog(JFrame frame, String initialAnnotation) {
		super(frame);
		prepareDialogObject(initialAnnotation);
	}
	
	private void prepareDialogObject(String initialAnnotation) {
	    
		initialize();
		this.setModal(true);
		
		if (null == initialAnnotation)
        {
            this.getTxtAreaAnnotation().setText("");
        }
        else
        {
            this.getTxtAreaAnnotation().setText(initialAnnotation);
        }
		
		setListeners();
		
		
		
	}
	

	protected void initialize() {
		try {
			GridBagLayout thisLayout = new GridBagLayout();
			thisLayout.columnWeights = new double[] {0.9,0.1};
			thisLayout.columnWidths = new int[] {7,7};
			thisLayout.rowWeights = new double[] {0.9,0.1};
			thisLayout.rowHeights = new int[] {7,7};
			this.getContentPane().setLayout(thisLayout);
			this.setTitle("Default Annotation Provider");
			this.setLocation(new java.awt.Point(300, 300));
			this.setModal(true);
			{
				btnOk = new JButton();
				this.getContentPane().add(btnOk, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.LINE_END, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
				btnOk.setText("Ok");
			}
			{
				btnCancel = new JButton();
				this.getContentPane().add(btnCancel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.LINE_START, GridBagConstraints.NONE, new Insets(0, 5, 0, 0), 0, 0));
				btnCancel.setText("Cancel");
			}
			{
				annotationPanel = new DefaultAnnotationProviderJPanel();
				this.getContentPane().add(
					getAnnotationPanel(),
					new GridBagConstraints(
						0,
						0,
						2,
						1,
						0.0,
						0.0,
						GridBagConstraints.CENTER,
						GridBagConstraints.BOTH,
						new Insets(0, 0, 0, 0),
						0,
						0));
			}
			setSize(400, 300);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	protected void setListeners() 
	{

		this.getBtnOk().addActionListener(new ActionListener(){

			@Override
            public void actionPerformed(ActionEvent e) 
			{
				exitedOnOk = true;
				setVisible(false);
				
			}});
		
		this.getBtnCancel().addActionListener(new ActionListener(){

			@Override
            public void actionPerformed(ActionEvent e) 
			{
				doCancel();
				setVisible(false);
				
				
			}});
		
		this.addWindowListener(new WindowAdapter(){

			@Override
            public void windowClosing(WindowEvent e) 
			{
				// TODO ask user if he wants to save changes or not when hitting the "x" to close the dialog
				doCancel();
				
			}
		});
		
		
	}

	
	protected void doCancel() {
		exitedOnOk = false;		
	}

	public JButton getBtnOk() {
		return btnOk;
	}
	
	public JButton getBtnCancel() {
		return btnCancel;
	}
	
	public DefaultAnnotationProviderJPanel getAnnotationPanel() {
		return annotationPanel;
	}
	
	public JLabel getLblHeader() {
		return getAnnotationPanel().getLblHeader();
	}
	
	public JTextArea getTxtAreaAnnotation() {
		return getAnnotationPanel().getTxtAreaAnnotation();
	}

	public boolean exitedOnOk() {
		return exitedOnOk;
	}	
	
	public String getText()
	{
		return getTxtAreaAnnotation().getText();
	}
}
