package com.sonicsw.ma.plugin;
import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.WindowConstants;


public class DefaultAnnotationProviderJPanel extends javax.swing.JPanel {
/*
	// Commented out - this is set by the MgmtConsole
	{
		//Set Look & Feel
		try {
			javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
*/
	
	private static final long serialVersionUID = 1L;
	protected JLabel lblHeader;
	protected JTextArea txtAreaAnnotation;
	protected JScrollPane textAreaScrollPane;

	public static void main(String[] args) {
		JFrame frame = new JFrame();
		frame.getContentPane().add(new DefaultAnnotationProviderJPanel());
		frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		frame.pack();
		frame.setVisible(true);
	}
	
	public DefaultAnnotationProviderJPanel() {
		super();
		initialize();
	}
	
	protected final void initialize() {
		try {
			BorderLayout thisLayout = new BorderLayout();
			this.setLayout(thisLayout);
			setPreferredSize(new Dimension(400, 300));
			{
				lblHeader = new JLabel();
				this.add(lblHeader, BorderLayout.NORTH);
				lblHeader.setText("Annotation");
			}
			{
				textAreaScrollPane = new JScrollPane();
				this.add(getTextAreaScrollPane(), BorderLayout.CENTER);
				{
					txtAreaAnnotation = new JTextArea();
					textAreaScrollPane.setViewportView(txtAreaAnnotation);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public JLabel getLblHeader() {
		return lblHeader;
	}
	
	public JTextArea getTxtAreaAnnotation() {
		return txtAreaAnnotation;
	}
	
	public JScrollPane getTextAreaScrollPane() {
		return textAreaScrollPane;
	}

}
