package com.sonicsw.ma.plugin;

import javax.swing.JTextField;

import modelobjects.framework.EditRule;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.swing.JTextFieldAdapter;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.ResourceManager;

public class EditPluginDialog extends JPropSheetDialog
{
    public static final int MODE_CREATE = 0;
    public static final int MODE_EDIT = 1;

    private JTextField m_textName = new JTextField(30);

    private Model m_model;
    private int m_mode = MODE_CREATE;

    public EditPluginDialog(JMAFrame parent)
    {
        this(parent, MODE_CREATE, null);
    }

    public EditPluginDialog(JMAFrame parent, int mode, IPlugin plugin)
    {
        super(parent, null, EditPluginDialog.Model.class);

        m_mode  = mode;
        m_model = new Model(plugin);
        setProperties();
    }
    
    private void setProperties() {
        setResizable(false);
        setTitle();
    }

    @Override
    public void maInitialize()
    {
        super.maInitialize();

        try
        {
            super.editInstance(null, m_model, false);

            // More consistent and usable if the "old" name is selected
            // so that the user can just type over it with the new name.
            m_textName.setSelectionStart(0);
            m_textName.setSelectionEnd(m_textName.getText().length());
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR, "Unable to initialize dialog.", e, true);
        }
    }

    @Override
    public void initUI() throws Exception
    {
        JPartitionPanel panel = new JPartitionPanel("");

        panel.addRow("Name", m_textName);

        super.getContentPane().add(JPartitionPanel.wrap(panel));
    }

    @Override
    public void initForm() throws Exception
    {
        new JTextFieldAdapter(ModelAspectId.forName("name"), m_textName,
                              EditRule.ALWAYS, null, getMediator());
    }

    protected void setTitle()
    {
        if (m_mode == MODE_CREATE)
        {
            setTitle(ResourceManager.getString(getClass(), "dialog.create.folder.title"));
        }
        else if (m_model.getPlugin() != null)
        {
            StringBuffer sbTitle = new StringBuffer(ResourceManager.getString(getClass(), "dialog.edit.title"));
            sbTitle.append(" ").append(m_model.getPlugin().getAttributes().getDisplayType());

            setTitle(sbTitle.toString());
        }
    }

    public class Model
    {
        private IPlugin m_plugin = null;
        private String  m_name   = null;

        public Model(IPlugin plugin)
        {
            setPlugin(plugin);
        }

        public String getName()
        {
            return m_name;
        }

        public void setName(String name)
        {
            m_name = name;
        }

        public IPlugin getPlugin()
        {
            return m_plugin;
        }

        public final void setPlugin(IPlugin plugin)
        {
            m_plugin = plugin;

            if (plugin != null)
            {
                m_name = plugin.getPluginName();
            }
        }
    }
}