package com.sonicsw.ma.plugin;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

import com.sonicsw.ma.gui.util.Helper;

public class FileAssociationToolInfo extends CommandLineToolInfo
{
    private static final String WIN_CMD = "cmd.exe /c \"start /wait {0} \"";

    /**
     * Creates a FileAssociationToolInfo
     * @param name
     * @param description
     * @param file - file to launch associated editor.
     */
    public FileAssociationToolInfo(String name, String description, File file)
    {
        super(null, name, description, null, file, false);
    }

    /**
     * Creates a FileAssociationToolInfo
     * @param file - file to launch associated editor.
     */
    public FileAssociationToolInfo(File file)
    {
        m_fileArgument = file;

        commonInit(null, null, null, false);
    }

    @Override
    protected String createCommand()
        throws IOException
    {
        StringBuffer sb = new StringBuffer();

        if (m_fileArgument != null)
        {
            if (m_fileArgument.exists())
            {
                if (Helper.isWindowsPlatform())
                {
                    sb.append(MessageFormat.format(WIN_CMD, new Object[] { m_fileArgument.getAbsolutePath() }));
                }
                else
                {
                    sb.append("").append(" ").append(m_fileArgument.getAbsolutePath());
                }
            }
            else
            {
                throw new IOException("Could not find file [" + m_fileArgument.getAbsolutePath() + "]");
            }
        }
        return sb.toString();
    }
}