// Copyright (c) 2009 Progress Software Corporation. All Rights Reserved.
package com.sonicsw.ma.plugin;

import java.awt.Window;

/**
 * <p>Title:IConfigExtensionProvider </p>
 * <p>Description: The interface definition for callback handler - implemented by third party </p>
 * @version 1.0
 */
public interface IAnnotationProvider
{
    /**
     * Called to determine whether configuration supports annotation. If true is returned puts the  
     * 'Association' menu item | button on particular configuration screen
     *
     * @param  type - The type of configuration element(MF/MQ configuration or ESB configuration types)
     * @param  version - The version of configuration type               
     * @return boolean true if type supports annotation
     */
    public boolean isAnnotationSupported(String type, String cVersion, String pVersion);

    /**
     * Opens Annotation Editor Dialog, and passes all relevant data required for creating/editing      
     * annotation.
     *
     * @param  type - The type of configuration element(MF/MQ configuration, ESB configuration)
     * @param  version - The version of configuration type
     * @param  data - string representation of data passed to the Association Editor. Could be null.  
     * @param  parent - The parent java.awt.Window for the Annotation Editor Dialog. Window is used to provide flexibility of using JFrame or JDialog.
     *
     * @return String - The data configured in Annotation Editor(string could be in any format, most  
     *                  likely it will be used xml format, however nothing restrict user to use any    
     *                  customized format type). 
     *                  The following return value are valid:
     *                      null -> cancel from editing
     *                      empty string -> clears existing annotation data.
     *          
     */
    public String openAnnotationEditor(String type, String cVersion, String pVersion, String data, Window parent);
}
