package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;

public interface IContainerExtensionFactory
{
    public String getId();
    public String getDescription();
    public String getConfigType();
    public String getConfigVersion();
    
    public JConfigDialog getPropertySheet(JConfigDialog parent, IPluginContext context) throws Exception;
    
    public IConfigBean createModel(IConfigBean containerBean) throws ConfigServiceException;
    
    public boolean isComponentDependent(String type, String productVersion, String configVersion);
    
    public void modelCreated(IConfigBean createdBean) throws ConfigServiceException;
    public void modelCopied(IConfigBean copiedBean) throws ConfigServiceException;
}
