/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.plugin;

import java.util.List;
import java.util.Map;

import javax.swing.AbstractButton;
import javax.swing.JComponent;

import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.mx.config.IConfigServer;

/**
 * Main Plugin interface used by both ConfigPlugins and RuntimePlugins
 */
public interface IPlugin extends IMonitorPlugin
{
    public static final int NEW_TYPE        = 1;
    public static final int PLUGIN_TYPE     = 2;
    public static final int EDIT_TYPE       = 3;
    public static final int SYSTEM_TYPE     = 4;
    public static final int VIEW_TYPE       = 5;
    public static final int PROPERTIES_TYPE = 6;
    public static final int PERMISSIONS_TYPE = 7;


    public void dispose();

    public Object getModel();

    @Override
    public String getPluginName();
    public void setPluginName(String strName);

    @Override
    public String getPluginPath();

    public PluginAttributes getAttributes();

    public JComponent[] getMenuItems(int type);

    public BasicAction getDefaultAction();

    public AbstractButton[] getToolbarItems();

    public IPluginContext getPluginContext();

    public IContentPane getPluginContentPane();

    public IPluginFilter getFilter();
    public void setFilter(IPluginFilter filter);
    public boolean isFilterLocal();

    /**
     * Get a list of Strings that are to be used when building the tooltip
     * diplayed for this plugin
     * @return a list of Strings containing tooltip information
     */
    public List getToolTipList();

    /**
     * This method is called when the user has entered a new name for this
     * plugin. The plugin receiving this call will perform any additional
     * operations prior to calling into the ViewManager to rename the
     * link in the view.
     *
     * @param  server     (transaction) config server to use for the rename
     * @param  newName    the new name for this link
     * @throws Exception  if for some reason the operation cannot be performed
     *                    or completed then an exception will be thrown
     */
    public void renamePlugin(IConfigServer server, String newName)
        throws Exception;

    /**
     * This method is called when the plugin (and any data representing it)
     * is to be deleted. The implementation is responsible for removing any
     * child plugin's and associated data.
     *
     * The plugin(s) are removed from the tree/content pane asynchronously
     * by notification from the Directory Service.
     *
     * @param server      (transaction) config server to use for the delete
     * @throws Exception  if for some reason the operation cannot be performed
     *                    or completed then an exception will be thrown
     */
    public void deletePlugin(IConfigServer server)
        throws Exception;

    /**
     * This method is called when the plugin (and any data representing it)
     * is to be copied. The implementation is responsible for creating the
     * new plugin and associated data.
     *
     * In most cases, it is the data that is the underlying data that needs
     * to be created...and this creation kicks off notification events that
     * result in plugins being added to the appropriate views.
     *
     * @param server      (transaction) config server to use for the copy
     * @param path        the new location of the plugin copy
     * @param copyData    implementation-specific data needed to control
     *                    the copy operation, e.g. instance, template copies
     * @throws Exception  if for some reason the operation cannot be performed
     *                    or completed then an exception will be thrown
     */
    public void copyPlugin(IConfigServer server, String path, Object copyData)
        throws Exception;

    public void refresh();


    /**
     * A parent plugin receives this notification to add a child plugin
     */
    public void onAdded(String childName, Map attributes);

    /**
     *
     */
    public void onUpdated();

    /**
     * A parent plugin receives this notification when it needs to remove a
     * child plugin
     */
    public void onDeleted(IPlugin childPlugin);

    /**
     * A plugin receives this notification when it needs to rename itself
     */
    public void onRenamed(String newName);

    public JPropSheetDialog getPropSheetDialog();
}
