package com.sonicsw.ma.plugin;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;

/**
 * Provides context based services for plugins to a MA application.
 */
public interface IPluginContext
{
    /**
     * Get the Configuration Specific Context
     */
    public IConfigContext getConfigContext();

    /**
     * Get the Runtime Specific Context
     */
    public IRuntimeContext getRuntimeContext();

    /**
     * Get information about the domain that is currently connected to
     */
    public DomainConnectionModel getConnectionInfo();

    /**
     * Get the library containing information about all plugin factories,
     * tools etc.
     */
    public MFLibraryMap getLibrary();

    /**
     * Create this context
     */
    public void create() throws Exception;

    /**
     * Destroy this instance of the plugin context
     */
    public void destroy();

    /**
     * Get the workspace window associated with this context
     */
    public WorkspaceWindow getWorkspace();

    /**
     * Get a reference to the management console
     */
    public MgmtConsole getMgmtConsole();
}