package com.sonicsw.ma.plugin;

import java.util.Map;

import com.sonicsw.mf.common.dirconfig.IDirElement;

/**
 * Each plugin to the MA tools is required to provide a plugin factory that
 * implements either IConfignPluginFactory or IRuntimePluginFactory
 * (which extend this interface). Not all plugins will have a runtime
 * aspect (e.g. JMS Administered Objects or certificates).
 *
 * Plugins can parent other plugins e.g. a message broker plugin may
 * parent a security domain plugin. Likewise plugin factories will parent
 * the corresponding child factories.
 *
 * MA applications accept an initialization file that defines the set
 * of parent plugin factories that the MA applications will be aware of.
 *
 * @see com.sonicsw.ma.plugin.IConfigPluginFactory
 * @see com.sonicsw.ma.plugin.IRuntimePluginFactory
 */
public interface IPluginFactory
{
    /**
     * Called when the factory is being created to pass it an additional
     * configuration settings from the DS
     * @param element
     * @throws java.lang.Exception
     */
    public void init(IDirElement element) throws Exception;

    /**
     * Creates a plugin.
     *
     * @param holder  The holder provides the plugin access to resources it
     *                needs to function within the framework
     * @param id      A string that uniquely identifies the plugin
     * @param version A string that specifies the product version for the new
     *                plugin. A PluginFactory can potentially create many
     *                product versions of configurations, all with the same
     *                configuration version
     * @param data    A map of additional creation data
     *
     * @return        A plugin instance
     */
    public IPlugin createPlugin(IPluginContext context, String id, String version, Map data)
    throws Exception;

    /**
     * Returns all the attributes associated with the Plugin Factory.
     * These are generally used as defaults for the Plugin instances.
     *
     * @return  The plugin factory attributes.
     */

    public PluginAttributes getAttributes();

    /**
     * Gets the list of child plugin factories.
     *
     * It should always return a non-null value.
     * No children would produce a return value of IPluginFactory[0].
     */
    public IPluginFactory[] getChildFactories();
}
