/**
 * Copyright (c) 2003 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import com.sonicsw.ma.gui.MgmtConsole;

/**
 * <p>Title: JarFileCache</p>
 * <p>Description: This class manages the caching of plugin files accessible via the Sonic DS. </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: Sonic Software Corporation</p>
 * @author Jeffrey S. Pace
 * @version 1.0
 */
public class JarFileCache
{
    // Singleton Instance
    private static JarFileCache m_cache = null;

    // No need for these variables to be static because they are inside the cache class and
    // it is a singleton!
    protected Collection m_colJarFiles = Collections.synchronizedCollection(new ArrayList());
    protected String m_strCachePath = System.getProperty("user.home") + File.separator + ".smc_cache";

    /**
     * JarFileCache
     */
    protected JarFileCache()
    {
    }

    /**
     * getInstance
     * @return
     */
    public static synchronized JarFileCache getInstance()
    {
        // If there is no instance at all...
        if (m_cache == null)
        {
            // Create one.
            m_cache = new JarFileCache();
        }

        // Return the one instance.
        return m_cache;
    }

    /**
     * getCachePath
     * @return
     */
    public static String getCachePath()
    {
        return getInstance().m_strCachePath;
    }

    /**
     * add
     * @param fileJar
     */
    public static void add(PluginJarFile fileJar)
    {
        getInstance().m_colJarFiles.add(fileJar);

        try
        {
            boolean bNeedsUpdating = true;

            if (fileJar.isCached())
            {
                // update only if needed and not in use...
                bNeedsUpdating = fileJar.needsUpdating();
            }

            if (bNeedsUpdating)
            {
                // cache jar files that were not in the cache, and those that need an update (if all can be updated)
                fileJar.cacheFile();
            }
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.getMgmtConsole(),
                MgmtConsole.MESSAGE_WARNING, "Could not load " + fileJar.getRelativePath() + " from DS.",
                e, true);
        }
    }

    /**
     * remove
     * @param fileJar
     */
    public static void remove(PluginJarFile fileJar)
    {
        getInstance().m_colJarFiles.remove(fileJar);
    }
}