/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.swing.JComponent;

/**
 * This class is a hash map of all of the RootLevel PluginFactoriesInfo objects
 * This hasMap is keyed by the RootPluginFactory's type/version (as obtained by
 * ConfigFactoryInfo.getKey()).
 *
 * @see com.sonicsw.ma.plugin.ConfigFactoryInfo;
 */

public final class MFLibraryMap
{
    private HashMap m_configMap   = new HashMap();  // Keyed off type
    private HashMap m_runtimeMap  = new HashMap();  // Keyed off type
    private HashMap m_toolMap     = new HashMap();
    private HashMap m_editorMap   = new HashMap();
    
    //--------------------------------------------------------------------------
    // Methods for Config Plugin Map
    //
    public void addConfigRootFactoryInfo(ConfigFactoryInfo info)
    {
        PluginAttributes attributes = info.getRootFactory().getAttributes();

        String type = attributes.getType();

        ArrayList list = (ArrayList)m_configMap.get(type);

        if(list == null)
        {
            list = new ArrayList();
            m_configMap.put(type, list);
        }
        list.add(info);
    }

    public HashMap getConfigRootFactoryMap()
    {
        return m_configMap;
    }

    /**
     * Get a specific child plugin
     */
    public IConfigPluginFactory getChildConfigPluginFactory(String type, String cVersion, String pVersion)
    {
        IConfigPluginFactory factory = null;

        // m_configMap is a map of ArrayLists since there can
        // be many root factories with the same type.
        Iterator iter = m_configMap.values().iterator();
        while (iter.hasNext() && (factory == null))
        {
            // The ArrayList contains ConfigFactoryInfos for each root factory
            ArrayList list = (ArrayList)iter.next();
            for(int i = 0; i < list.size(); i++)
            {
                if((factory = ((ConfigFactoryInfo)list.get(i)).
                    getChildFactory(type, cVersion, pVersion)) != null)
                {
                    // We could have many factories for a particular type and
                    // for the specified config version. So we will choose
                    // the one with the highest version number ??

                    // AJB - not yet implemented.
                    break;
                }
            }
        }
        return factory;
    }

    //--------------------------------------------------------------------------
    // Methods for Runtime Plugin Map
    //
    public void addRuntimeRootFactoryInfo(RuntimeFactoryInfo info)
    {
        PluginAttributes attributes = info.getRootFactory().getAttributes();

        String type = attributes.getType();

        ArrayList list = (ArrayList)m_runtimeMap.get(attributes.getType());

        if(list == null)
        {
            list = new ArrayList();
            m_runtimeMap.put(type, list);
        }
        list.add(info);
    }

    public HashMap getRuntimeRootFactoryMap()
    {
        return m_runtimeMap;
    }

    /**
     * Get a specific child plugin
     */
    public IRuntimePluginFactory getChildRuntimePluginFactory(String type, String cVersion, String pVersion)
    {
        IRuntimePluginFactory factory = null;

        // m_runtimeMap is a map of ArrayLists since there can
        // be many root factories with the same type.
        Iterator iter = m_runtimeMap.values().iterator();
        while (iter.hasNext() && (factory == null))
        {
            // The ArrayList contains RuntimeFactoryInfos for each root factory
            ArrayList list = (ArrayList)iter.next();
            for(int i = 0; i < list.size(); i++)
            {
                if((factory = ((RuntimeFactoryInfo)list.get(i)).
                    getChildFactory(type, cVersion, pVersion)) != null)
                {
                    // We could have many factories for a particular type and
                    // for the specified config version. So we will choose
                    // the one with the highest version number ??

                    // AJB - not yet implemented.
                    break;
                }
            }
        }
        return factory;
    }


    /**
     * Returns the set of runtime plugin types that can be directly seen using
     * the runtime framework, e.g. containers, collections.
     *
     * @return  a string array of plugin (configuration) types
     */
    public String[] getRootRuntimePluginTypes()
    {
        ArrayList res = new ArrayList();

        Iterator iter = m_runtimeMap.values().iterator();

        while (iter.hasNext())
        {
            ArrayList list = (ArrayList)iter.next();

            for(int i = 0; i < list.size(); i++)
            {
                RuntimeFactoryInfo info = (RuntimeFactoryInfo)list.get(i);

                Iterator iter2 = info.getChildFactoryMap().values().iterator();

                while(iter2.hasNext())
                {
                    PluginAttributes attributes = ((IPluginFactory)iter2.next()).getAttributes();

                    if (attributes.isRuntimeRoot() && !res.contains(attributes.getType()))
                    {
                        res.add(attributes.getType());
                    }
                }
            }
        }
        return (String[])res.toArray(new String[res.size()]);
    }

    //--------------------------------------------------------------------------
    // Methods for Tools Map
    //
    public HashMap getToolsMap()
    {
        return m_toolMap;
    }

    public void addToolInfo(ToolInfo info)
    {
        m_toolMap.put(info.getKey(), info);
    }

    /**
     *  Builds a menu containing all of the items that will go on the tools menu
     */
    public JComponent[] getToolsMenuItems()
    {
        ArrayList list = new ArrayList();

        for(Iterator iter = m_toolMap.keySet().iterator(); iter.hasNext(); )
        {
            ToolInfo info = (ToolInfo)m_toolMap.get(iter.next());

            if ((info instanceof ClasspathToolInfo) && !((ClasspathToolInfo)info).isVisibleInMenu())
            {
                continue;
            }

            list.add(info.getMenuItem());
        }
        return (JComponent[])list.toArray(new JComponent[list.size()]);
    }

    //--------------------------------------------------------------------------
    //
    // Annotation provisioning
    //
    //--------------------------------------------------------------------------
 
    private List m_annotationList = null;

    public void addAnnotationProvider(IAnnotationProvider provider)
    {
    	if (provider == null)
        {
            return;
        }
    	
        if (m_annotationList == null)
        {
            m_annotationList = new ArrayList();
        }
        
        m_annotationList.add(provider);
    }
    
    public IAnnotationProvider getAnnotationProvider(String type, String cVersion, String pVersion)
    {
    	if (m_annotationList == null)
        {
            return null;
        }
    	
    	Iterator i = m_annotationList.iterator();
    	
    	while (i.hasNext())
    	{
    		IAnnotationProvider provider = (IAnnotationProvider)i.next();
    		
    		if (provider.isAnnotationSupported(type, cVersion, pVersion))
            {
                return provider;
            }
    	}
    	
    	return null;
    }
    
    //--------------------------------------------------------------------------
    // Methods for Editor Map
    //
    public HashMap getEditorsMap()
    {
        return m_editorMap;
    }

    public void addEditorInfo(EditorInfo info)
    {
        m_editorMap.put(info.getKey(), info);
    }
}