/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.plugin;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class PathWrapper
{
    private String   m_path;
    private String[] m_components;

    public PathWrapper(String path)
    {
        m_path = path;

        // skip the first separator - will always be at least one
        path = path.substring(path.indexOf('/')+1);

        ArrayList       list = new ArrayList();
        StringTokenizer st = new StringTokenizer(path, "/");

        while (st.hasMoreTokens())
        {
            list.add(st.nextToken());
        }

        m_components = (String[])list.toArray(new String[list.size()]);
    }

    public String getPath()
    {
        return m_path;
    }

    public String[] getPathComponents()
    {
        return m_components;
    }

    public String getRootPath()
    {
        StringBuffer sb = new StringBuffer();

        for (int i = 0; i < m_components.length-1; i++)
        {
            sb.append("/").append(m_components[i]);
        }

        return sb.toString();
    }

    public String getLastElement()
    {
        return m_components[m_components.length-1];
    }

    public String getName()
    {
        return getLastElement();
    }

    public int getSize()
    {
        return (m_components != null) ? m_components.length : 0;
    }

    public PathWrapper subpath(int startIndex, int endIndex)
    {
        StringBuffer sb = new StringBuffer();

        for (int i = startIndex; i < startIndex + endIndex; i++)
        {
            sb.append("/").append(m_components[i]);
        }

        return new PathWrapper(sb.toString());
    }

    @Override
    public String toString()
    {
        return m_path;
    }

}
