/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.plugin;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.util.JRowTable;

public class PluginDnd implements DragGestureListener,
                                  DragSourceListener,
                                  DropTargetListener
{
    public static final DataFlavor FLAVOR_PLUGIN = new DataFlavor(IConfigPlugin.class, "Sonic SMC Configuration Plugin");

    private Component m_comp;

    public PluginDnd(Component comp)
    {
        m_comp = comp;

        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(m_comp, DnDConstants.ACTION_LINK, this);

        new DropTarget(m_comp, DnDConstants.ACTION_LINK, this);

        if (m_comp instanceof JTable)
        {
            JScrollPane sp = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, m_comp);

            new DropTarget(sp, DnDConstants.ACTION_LINK, this);
        }
    }

    protected void setCursor(DragSourceContext context, int dragAction, boolean allowed)
    {
        switch (dragAction)
        {
            case DnDConstants.ACTION_COPY_OR_MOVE :
            case DnDConstants.ACTION_COPY : context.setCursor(allowed ? DragSource.DefaultCopyDrop : DragSource.DefaultCopyNoDrop);  break;
            case DnDConstants.ACTION_MOVE : context.setCursor(allowed ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);  break;
            case DnDConstants.ACTION_LINK : context.setCursor(allowed ? DragSource.DefaultLinkDrop : DragSource.DefaultLinkNoDrop);  break;
        }
    }

    //-------------------------------------------------------------------------
    //
    // DragGestureListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void dragGestureRecognized(DragGestureEvent evt)
    {
        Point   dragPos    = evt.getDragOrigin();
        IPlugin dragPlugin = null;

        if (evt.getComponent() instanceof JRowTable)
        {
            JRowTable dragComp = (JRowTable)evt.getComponent();
            int       dragRow  = dragComp.rowAtPoint(dragPos);

            if ((dragRow >= 0) && dragComp.isRowSelected(dragRow))
            {
                dragPlugin = (IPlugin)((IModelTableModel)dragComp.getModel()).getRowModel(dragRow);
            }
        }
        else
        if (evt.getComponent() instanceof JTree)
        {
            JTree    dragComp = (JTree)evt.getComponent();
            TreePath dragPath = dragComp.getPathForLocation(dragPos.x, dragPos.y);

            if (dragPath != null)
            {
                Object obj = dragPath.getLastPathComponent();

                if (obj instanceof IPlugin)
                {
                    dragPlugin = (IPlugin)obj;
                }
            }
        }

        if ((dragPlugin != null) &&
            (dragPlugin instanceof IConfigPlugin) &&
               ((IConfigPlugin)dragPlugin).isDragSupported(DnDConstants.ACTION_LINK))
        {
            evt.startDrag(DragSource.DefaultLinkNoDrop, new PluginTransferable(dragPlugin), this);
        }
    }

    //-------------------------------------------------------------------------
    //
    // DragSourceListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void dragDropEnd(DragSourceDropEvent evt)
    {
    }

    @Override
    public void dragExit(DragSourceEvent evt)
    {
        setCursor(evt.getDragSourceContext(),
                  evt.getDragSourceContext().getTrigger().getDragAction(),
                  false);
    }

    @Override
    public void dragOver(DragSourceDragEvent evt)
    {
        setCursor(evt.getDragSourceContext(), evt.getDropAction(), true);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent evt)
    {
        dragOver(evt);
    }

    @Override
    public void dragEnter(DragSourceDragEvent evt)
    {
        dragOver(evt);
    }

    //-------------------------------------------------------------------------
    //
    // DropTargetListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void drop(DropTargetDropEvent evt)
    {
        int errCode = 0;
        IConfigPlugin dropPlugin = null;
        IConfigPlugin dragPlugin = null;

        try
        {
            if (evt.isDataFlavorSupported(FLAVOR_PLUGIN))
            {
                DropTargetContext context = evt.getDropTargetContext();

                if (context.getComponent() instanceof JTree)
                {
                    JTree    tree  = (JTree)context.getComponent();
                    Point    point = evt.getLocation();
                    TreePath path  = tree.getPathForLocation(point.x, point.y);

                    if (path != null)
                    {
                        Object obj = path.getLastPathComponent();

                        if (obj instanceof IConfigPlugin)
                        {
                            dropPlugin = (IConfigPlugin)obj;
                        }
                    }
                }
                else
                if (context.getComponent() instanceof JRowTable)
                {
                    JRowTable table = (JRowTable)context.getComponent();
                    Point     point = evt.getLocation();
                    int       row   = table.rowAtPoint(point);

                    if (row >= 0)
                    {
                        dropPlugin = (IConfigPlugin)((IModelTableModel)table.getModel()).getRowModel(row);
                    }
                }
            }

            dragPlugin = (IConfigPlugin)evt.getTransferable().getTransferData(FLAVOR_PLUGIN);

            if ((dragPlugin != null) && (dropPlugin != null) &&
                (dragPlugin != dropPlugin) &&
                dropPlugin.isDropSupported(evt.getDropAction()))
            {
                evt.acceptDrop(evt.getDropAction());

                dropPlugin.drop(dragPlugin, evt.getDropAction());
            }
            else
            {
                errCode = -1;
            }
         }
         catch (Exception e)
         {
             e.printStackTrace();
             errCode = 1;
         }

         if (errCode == -1)
        {
            evt.rejectDrop();
        }
        else
        {
            evt.dropComplete((errCode == 0));
        }
    }

    @Override
    public void dragExit(DropTargetEvent evt)
    {
    }

    @Override
    public void dragOver(DropTargetDragEvent evt)
    {
        DropTargetContext context    = evt.getDropTargetContext();
        IConfigPlugin     dropPlugin = null;

        try
        {
            if (context.getComponent() instanceof JTree)
            {
                JTree    tree  = (JTree)context.getComponent();
                Point    point = evt.getLocation();
                TreePath path  = tree.getPathForLocation(point.x, point.y);

                if (path != null)
                {
                    Object obj = path.getLastPathComponent();

                    if (obj instanceof IConfigPlugin)
                    {
                        dropPlugin = (IConfigPlugin)obj;
                    }
                }
            }
            else
            if (context.getComponent() instanceof JRowTable)
            {
                JRowTable table = (JRowTable)context.getComponent();
                Point     point = evt.getLocation();
                int       row   = table.rowAtPoint(point);

                if (row >= 0)
                {
                    dropPlugin = (IConfigPlugin)((IModelTableModel)table.getModel()).getRowModel(row);
                }
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }

        boolean allowed = ((dropPlugin != null) && dropPlugin.isDropSupported(evt.getDropAction()));

        if (allowed)
        {
            evt.acceptDrag(evt.getDropAction());
        }
        else
        {
            evt.rejectDrag();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt)
    {
        dragOver(evt);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt)
    {
        dragOver(evt);
    }

    //-------------------------------------------------------------------------

    class PluginTransferable implements Transferable, ClipboardOwner
    {
        private IPlugin m_plugin;

        /**
         * Creates a <code>Transferable</code> capable of transferring
         * the specified <code>IPlugin</code>.
         */
        public PluginTransferable(IPlugin plugin)
        {
            m_plugin = plugin;
        }

        /**
         * Returns an array of flavors in which this <code>Transferable</code>
         * can provide the data. <code>DataFlavor.stringFlavor</code>
         * is properly supported.
         * Support for <code>DataFlavor.plainTextFlavor</code> is
         * <b>deprecated</b>.
         *
         * @return an array of length two, whose elements are <code>DataFlavor.
         *         stringFlavor</code> and <code>DataFlavor.plainTextFlavor</code>
         */
        @Override
        public DataFlavor[] getTransferDataFlavors()
        {
            return new DataFlavor[] { FLAVOR_PLUGIN };
        }

        /**
         * Returns whether the requested flavor is supported by this
         * <code>Transferable</code>.
         *
         * @param flavor the requested flavor for the data
         * @return true if <code>flavor</code> is equal to
         *   <code>DataFlavor.stringFlavor</code> or
         *   <code>DataFlavor.plainTextFlavor</code>; false if <code>flavor</code>
         *   is not one of the above flavors
         * @throws NullPointerException if flavor is <code>null</code>
         */
        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor)
        {
            DataFlavor[] supported = getTransferDataFlavors();

            for (int i = 0; i < supported.length; i++)
            {
                if (flavor.equals(supported[i]))
                {
                    return true;
                }
            }

            return false;
        }

        /**
         * Returns the <code>Transferable</code>'s data in the requested
         * <code>DataFlavor</code> if possible. If the desired flavor is
         * <code>DataFlavor.stringFlavor</code>, or an equivalent flavor,
         * the <code>String</code> representing the selection is
         * returned. If the desired flavor is </code>DataFlavor.plainTextFlavor
         * </code>, or an equivalent flavor, a <code>Reader</code> is returned.
         * <b>Note:<b> The behavior of this method for
         * </code>DataFlavor.plainTextFlavor</code>
         * and equivalent <code>DataFlavor</code>s is inconsistent with the
         * definition of <code>DataFlavor.plainTextFlavor</code>.
         *
         * @param flavor the requested flavor for the data
         * @return the data in the requested flavor, as outlined above
         * @throws UnsupportedFlavorException if the requested data flavor is
         *         not equivalent to either <code>DataFlavor.stringFlavor</code>
         *         or <code>DataFlavor.plainTextFlavor</code>
         * @throws IOException if an IOException occurs while retrieving the data.
         *         By default, StringSelection never throws this exception, but a
         *         subclass may.
         * @throws NullPointerException if flavor is <code>null</code>
         * @see java.io.Reader
         */
        @Override
        public Object getTransferData(DataFlavor flavor)
        throws UnsupportedFlavorException, IOException
        {
            if (!flavor.equals(FLAVOR_PLUGIN))
            {
                throw new UnsupportedFlavorException(flavor);
            }

            return m_plugin;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents)
        {
        }

    }

    //-------------------------------------------------------------------------

}
