package com.sonicsw.ma.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigServer;

import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;

/**
 * Provides context based services for plugins to a MA application.
 */
public class RuntimeContext implements IRuntimeContext
{
    private IPluginContext m_pluginContext;
    private ArrayList      m_runtimeList;

    /**
     * Create a default runtime context
     */
    public RuntimeContext(IPluginContext context) throws Exception
    {
        m_pluginContext = context;
    }

    @Override
    public IRemoteMBeanServer getMBeanServer()
    {
        return m_pluginContext.getConnectionInfo().getMBeanServer();
    }

    /**
     * Get the Plugin Factory
     */
    @Override
    public IRuntimePluginFactory getPluginFactory(String type, String cVersion, String pVersion)
    {
        return m_pluginContext.getLibrary().getChildRuntimePluginFactory(type, cVersion, pVersion);
    }

    /**
     * Performs a number of queries on the DS to build up a list of top-level
     * root elements for the Runtime view. These elements are used to create
     * a default tree model.
     *
     * @return         A list of root runtime elements in the form of valid
     *                 DS FS (logical) paths
     */
    private ArrayList queryRuntimeRootElements()
    {
        if (m_runtimeList != null)
        {
            return m_runtimeList;
        }

        ArrayList     list   = new ArrayList();
        IConfigServer server = m_pluginContext.getConfigContext().getConfigServer();
        Query         query  = new Query();
        String[]      types  = m_pluginContext.getLibrary().getRootRuntimePluginTypes();

        for (int i = 0; i < types.length; i++)
        {
            try
            {
                Set set = server.listConfigElements(query.setFrom(new FromElementType(types[i])));

                if ((set == null) || set.isEmpty())
                {
                    continue;
                }

                Iterator iterator = set.iterator();

                while (iterator.hasNext())
                {
                    list.add((String)iterator.next());
                }
            }
            catch (ConfigServiceException e)
            {
                e.printStackTrace();
            }
        }
        m_runtimeList = list;

        return m_runtimeList;
    }

    @Override
    public boolean isRuntimePath(String path)
    {
        ArrayList list = queryRuntimeRootElements();

        if (list.contains(path))
        {
            return true;
        }

        Iterator i = list.iterator();

        while (i.hasNext())
        {
            String aPath = (String)i.next();

            if (aPath.startsWith(path))
            {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addRuntimePath(String path)
    {
        ArrayList list = queryRuntimeRootElements();

        if(!list.contains(path))
        {
            list.add(path);
        }
    }
}
