/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.plugin;

import java.awt.event.ActionEvent;

import javax.swing.JMenuItem;

import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.JBasicMenuItem;

/**
 * This class represents information about a ConfigPluginFactory tree.
 * It is initialized from a root plugin factory, and contains a hashmap
 * of all of the children plugins and a default menu structure that
 * represents the menu tree in hierarchical fashion
 */
public abstract class ToolInfo
{
    protected IPluginContext m_context;
    protected String  m_name;
    protected Integer m_mnemonic;
    protected String  m_description;
    protected boolean m_configure;

    protected ToolInfo() {}

    /**
     * common initialization.
     * @param context
     * @param name
     * @param description
     * @param configure
     */
    public final void commonInit(IPluginContext context, String name, String description, boolean configure)
    {
        m_context     = context;
        m_name        = name;
        m_description = description;
        m_configure   = configure;

        if (name != null)
        {
            int mIndex = name.indexOf('&');

            if (mIndex >= 0)
            {
                m_name = name.substring(0, mIndex) + name.substring(mIndex + 1);

                m_mnemonic = new Integer((int) name.charAt(mIndex + 1));
            }
        }
    }

    /**
     * gets the tool name
     * @return Object
     */
    public Object getKey()
    {
        return m_name;
    }

    /**
     * creates a menu item for this tool.
     * @return JMenuItem
     */
    public JMenuItem getMenuItem()
    {
        return new JBasicMenuItem(new ToolAction());
    }

    /**
     * canEnable
     * @return boolean
     */
    public abstract boolean canEnable();

    /**
     * execute
     */
    public abstract void execute();

    public static ToolInfo createInfo(IPluginContext context,
                                      ClassLoader classloader,
                                      String name,
                                      String desc,
                                      String app,
                                      String cls,
                                      boolean config)
    {
        ToolInfo tool = null;

        if (cls != null)
        {
            tool = new ClasspathToolInfo(context, name, desc, cls, classloader, config);
        }
        else
        {
            tool = new CommandLineToolInfo(context, name, desc, app, null, config);
        }

        return tool;
    }

    class ToolAction extends BasicGuiAction
    {
        public ToolAction()
        {
            super(null);
            putProperties();
        }
        
        private void putProperties() {
            putValue(BasicPluginAction.NAME,              m_name);
            putValue(BasicPluginAction.SHORT_DESCRIPTION, m_description);
            putValue(BasicPluginAction.LONG_DESCRIPTION,  m_description);
            putValue(BasicPluginAction.MNEMONIC_KEY,      m_mnemonic);
        }

        @Override
        public boolean isEnabled()
        {
            return canEnable();
        }

        @Override
        public void actionPerformed(ActionEvent event)
        {
            execute();
        }
    }
}
