package com.sonicsw.ma.util;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


public class FileTracker
{
    private static FileTracker _tracker = null;

    private static final long INTERVAL = 2000;

    private Map               m_map    = new HashMap();
    private FileTrackerThread m_thread = null;


    public FileTracker()  throws Exception
    {
        m_thread = new FileTrackerThread();
        m_thread.setDaemon(true);
        m_thread.setPriority(Thread.MIN_PRIORITY);
        m_thread.start();
    }

    public boolean _add(FileTrackerHandler handler)
    {
        if (handler.getFile().exists())
        {
            System.err.println("FileTracker::add '" + handler.getFile() + "'");

            m_map.put(handler.getFile(), handler);
        }

        return true;
    }

    public FileTrackerHandler _remove(File file)
    {
        if (file == null)
        {
            return null;
        }

        System.err.println("FileTracker::remove '" + file + "'");

        FileTrackerHandler handler = (FileTrackerHandler)m_map.remove(file);

        // If the map is empty, i.e. we are not tracking any files, then
        // we can shutdown the thread.
        //
        if ((m_map != null) && m_map.isEmpty())
        {
            m_thread.setStop(true);
            synchronized (FileTracker.class)
            {
                _tracker = null;
            }
        }

        return handler;
    }

    public static boolean add(FileTrackerHandler handler)
    {
        if ((handler == null) || (handler.getFile() == null))
        {
            return false;
        }

        synchronized (FileTracker.class)
        {
            if (_tracker == null)
            {
                try
                {
                    _tracker = new FileTracker();
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
            }
            return (_tracker != null) ? _tracker._add(handler) : false;
        }
    }

    public static synchronized FileTrackerHandler remove(File path)
    {
        return (_tracker == null) ? null : _tracker._remove(path);
    }

    public static FileTrackerHandler remove(FileTrackerHandler handler)
    {
        return remove((handler != null) ? handler.getFile() : null);
    }

    //-------------------------------------------------------------------------

    private class FileTrackerThread extends Thread
    {
        private boolean m_stop = false;

        public FileTrackerThread()
        {
            super("File Tracker");
        }

        public void setStop(boolean state)
        {
            m_stop = state;
        }

        @Override
        public void run()
        {
            System.err.println("FileTracker::thread starting");

            try
            {
                while (!m_stop)
                {
                    Iterator i = m_map.values().iterator();

                    while (i.hasNext() && !m_stop)
                    {
                        FileTrackerHandler handler = (FileTrackerHandler)i.next();

                        if (!handler.getFile().exists())
                        {
                            handler.fileDeleted();
                        }
                        else if (handler.isModified())
                        {
                            handler.fileModified();
                        }
                    }
                    sleep(INTERVAL);
                }
            }
            catch (InterruptedException e)
            {
                e.printStackTrace();
            }
            System.err.println("FileTracker::thread stopped");
        }
    }
}