package com.sonicsw.ma.util;

import java.io.File;


public abstract class FileTrackerHandler
{
    private File m_file;
    private long m_lastModified;

    public FileTrackerHandler(File file)
    {
        super();

        setFile(file);
    }

    /* package protected */ final void setFile(File file)
    {
        m_file         = file;
        m_lastModified = (m_file != null) ? m_file.lastModified() : -1;
    }

    public File getFile()
    {
        return m_file;
    }

    public boolean isModified()
    {
        long old = m_lastModified;

        m_lastModified = m_file.lastModified();

        return (old != m_lastModified);
    }

    public void fileDeleted()
    {
    }

    public void fileModified()
    {
    }

    public void fileFinished(int exitCode)
    {
        if ((exitCode == 0) && isModified())
        {
            fileModified();
        }
    }
}
