package com.sonicsw.mf.comm;


/**
 * Implementors are expected to handle connection changes reported by the connector.
 */
public interface IConnectionListener
{
    /**
     * Called when the connector reconnects to the underlying trasnport.
     *
     * @see IConnectorClient#setConnectionListener(IConnectionListener)
     */
    public void onReconnect(String localRoutingNode);

    /**
     * Called when the connector disconnects from the underlying trasnport.
     *
     * @see IConnectorClient#setConnectionListener(IConnectionListener)
     */
    public void onDisconnect();

    /**
     * Called when the connector detects some permanent failure in the underlying trasnport.
     *
     * @see IConnectorClient#setConnectionListener(IConnectionListener)
     */
    public void onFailure(Exception e);
}
