package com.sonicsw.mf.comm;

import progress.message.jclient.TopicConnectionFactory;

/**
 * The IDurableConnectorClient interface describes the methods to be implemented by
 * classes that create and use a DurableConnector instance.
 */
public interface IDurableConnectorConsumer
{
    public int getTraceMask();
    public TopicConnectionFactory getConnectionFactory();
    public IConnectionListener getConnectionListener();
    
    public void logMessage(String message, int severity);
    public void logMessage(String message, Throwable e, int severity);
    
    public void onReconnect(String localRoutingNode);
    public void onDisconnect();
    public void onFailure(Exception e);
}
