package com.sonicsw.mf.comm;


/**
 * Implementors are expected to handle permanent communications failures reported by the connector.
 */
public interface IExceptionListener
{
    /**
     * Called when a permanent (non-recoverable) exception occurs in the connector.
     *
     * @param exception The exception that describes the underlying failure.
     *
     * @see IConnectorClient#setExceptionListener(IExceptionListener)
     */
    public void onException(Exception exception);
}
