package com.sonicsw.mf.comm;

import com.sonicsw.mf.common.runtime.INotification;

public interface INotificationListener
{
    /**
     * Provides the communications type needed by the connector.
     *
     * Communications types are those supported by MF (although not
     * explicitely checked). At time of writing the following types may be
     * used:
     *
     *   - "mf" (intended for internal container-to-container use)
     *   - "jmx" (intended for JMX connector use)
     *
     * @return The communications type.
     */
    public String getListenerType();

    /**
     * This method will be called on the listener when a notification is
     * received by the underlying connector.
     */
    public void handleNotification(INotification notification, Object handback);
}
