package com.sonicsw.mf.comm;

/**
 * Implementors are expected to handle replies that arrive after requests have timed out.
 */
public interface IOrphanedReplyListener
{
    /**
     * Called when a valid reply arrives after the original request had timed out.
     *
     * @see ConnectorClient#setOrphanedReplyListener(IOrphanedReplyListener)
     */
    public void onSuccess(String target, String operationName, Object returnValue, long requestReceived, long requestCompleted);

    /**
     * Called when a exception reply arrives after the original request had timed out.
     *
     * @see ConnectorClient#setOrphanedReplyListener(IOrphanedReplyListener)
     */
    public void onFailure(String target, String operationName, Exception e, long requestReceived, long requestAborted);
}
