package com.sonicsw.mf.comm.jms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

import com.sonicsw.mf.common.runtime.IStateController;
import com.sonicsw.mf.common.runtime.IStateListener;
import com.sonicsw.mf.common.runtime.IStateManager;
import com.sonicsw.mf.common.runtime.NonRecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.RecoverableStateChangeException;

public class ConnectionStateManager
implements IStateManager
{
    //
    // data members
    //
    private short[] m_connectionStates;

    private short m_currentConnectionState;

    private HashMap m_connectionStateControllers = new HashMap();
    private HashSet m_connectionStateListeners = new HashSet();

    public static final String CONNECTOR_CLIENT_CLASSNAME = "ConnectorClient";

    public static final short CONNECT = 0;
    public static final short CONNECTING = 1;
    public static final short CONNECTED = 2;
    public static final short DISCONNECTING = 3;  // on shutdown of container

    //
    // constructor
    //
    public ConnectionStateManager( )
    {
        // set allowable state ranges
        m_connectionStates = new short[10];
        for (short i = 0; i < m_connectionStates.length; i++)
         {
            m_connectionStates[i] = i;   // yeah, should use the constants defined above, but this is more efficient and has the same result...
        }

        // set current states
        m_currentConnectionState = CONNECT;
    }

    @Override
    public synchronized short getState(Object obj)
    {
        // input "obj" should be a reference to a String
        if (!(obj instanceof String))
        {
            throw  new java.lang.IllegalArgumentException("Method getState(Object obj) of the ConnectionAndServiceStateManager class requires that the input 'obj' argument must refer to an object that is of type 'String', though the formal parameter is of type 'Object'.");
        }

        String str = (String) obj;
        if ( str.equalsIgnoreCase(CONNECTOR_CLIENT_CLASSNAME) )
        {
            return m_currentConnectionState;
        }
        else
        {
            throw new java.lang.IllegalArgumentException("Attempt to get state of unrecognized object: object name = " + obj.getClass().getName());
        }
    }

    @Override
    public synchronized boolean requestStateChange(short expectedCurrentState, short desiredState, Object obj)
    throws NonRecoverableStateChangeException, RecoverableStateChangeException
    {
        // input "obj" should be a reference to a String
        if (!(obj instanceof String))
        {
            throw  new java.lang.IllegalArgumentException("Method registerStateChange() of the ConnectionAndServiceStateManager class requires that the input 'obj' argument must refer to an object that is of type 'String', though the formal parameter is of type 'Object'.");
        }

        // determine what entity's state is being changed
        String str = (String) obj;
        if (str.equalsIgnoreCase(CONNECTOR_CLIENT_CLASSNAME))
        {
            return requestConnectionStateChange(expectedCurrentState, desiredState, obj);
        }
        else {
            return false;  // or should we throw an exception?
        }
    }

    @Override
    public synchronized void registerStateController(IStateController stateController, short fromState, short toState, Object obj)
    {
        if (!(obj instanceof String))
        {
            throw  new java.lang.IllegalArgumentException("Method registerStateController() of the ConnectionAndServiceStateManager class requires that the input 'obj' argument must refer to an object that is of type 'String', though the formal parameter is of type 'Object'.");
        }

        String str = (String) obj;
        if ( str.equalsIgnoreCase(CONNECTOR_CLIENT_CLASSNAME) )
        {
            // add the controller to the ConnectorClient's controller set

            // Make sure that the input states are valid
            if (!isValidState(fromState, CONNECTOR_CLIENT_CLASSNAME))
            {
                throw new IllegalArgumentException("Invalid state: " + fromState + ", for 'from' connection state.");
            }
            if (!isValidState(toState, CONNECTOR_CLIENT_CLASSNAME))
            {
                throw new IllegalArgumentException("Invalid state: " + toState + ", for 'to' connection state." );
            }

            String key = fromState + "," + toState;
            if (m_connectionStateControllers.containsKey(key))
            {
                throw new IllegalStateException("State controller for specified state transition already registered for connection.");
            }

            m_connectionStateControllers.put(key, stateController);
        }
    }

    @Override
    public synchronized void registerStateListener(IStateListener stateListener, Object obj)
    {
        if (!(obj instanceof String))
        {
            throw  new java.lang.IllegalArgumentException("Method registerStateListener() of the ConnectionAndServiceStateManager class requires that the input 'obj' argument must refer to an object that is of type 'String', though the formal parameter is of type 'Object'.");
        }

        String str = (String) obj;
        if ( str.equalsIgnoreCase(CONNECTOR_CLIENT_CLASSNAME) )
        {
            // add the listener to the ConnectorClient's listener set
            m_connectionStateListeners.add(stateListener);
        }
    }

    private boolean isValidState( short state, String str )
    {
        if (str.equalsIgnoreCase(CONNECTOR_CLIENT_CLASSNAME))
        {
            for (int i = 0; i < m_connectionStates.length; i++)
            {
                if (m_connectionStates[i] == state)
                {
                    return true;
                }
            }

            return false;
        }
        else
        {
            throw new java.lang.IllegalArgumentException("Attempt to test state of unrecognized object: object name = " + str);
        }
    }

    private synchronized boolean requestConnectionStateChange( short expectedCurrentState, short desiredState, Object obj)
    throws NonRecoverableStateChangeException, RecoverableStateChangeException
    {
        // make sure that the desired state is permissible
        if (!isValidState(desiredState, CONNECTOR_CLIENT_CLASSNAME))
        {
            throw new IllegalArgumentException("Invalid state: " + desiredState + ", for desired connection state.");
        }

        // the caller of this method should have called "getState" first and provided that state
        // as the first parameter - the caller provides the state obtained from that method call
        // as an input argument to this method call and, if the state has changed in between getting the
        // state and calling this method, this method will return false (the state change did not occur) .. in which case the
        // caller should reevaluate if it still desires to change the state
        if (expectedCurrentState != m_currentConnectionState)
        {
            return false;
        }

        // let all listeners know that a state is changing
        Iterator iterator = m_connectionStateListeners.iterator();
        while (iterator.hasNext())
        {
            ((IStateListener)iterator.next()).stateChanging(m_currentConnectionState, desiredState);
        }

        // if there is a controller for the change in state then call it
        String key = m_currentConnectionState + "," + desiredState;
        IStateController controller = (IStateController)m_connectionStateControllers.get(key);
        boolean stateChanged = (controller == null) ? true : controller.changeState();

        // let all the listeners know if the state changed succeeded or not
        iterator = m_connectionStateListeners.iterator();
        while (iterator.hasNext())
        {
            if (stateChanged)
            {
                ((IStateListener)iterator.next()).stateChanged(m_currentConnectionState, desiredState);
            }
            else
            {
                ((IStateListener)iterator.next()).stateChangeFailed(m_currentConnectionState, desiredState);
            }
        }

        if (stateChanged)
        {
            // update the current state and notify any waiters
            m_currentConnectionState = desiredState;
            super.notifyAll(); // we already have the mutex - this is a synchronized method
        }

        return stateChanged;
    }
}