/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common;

import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;

/* An interface implemented by the DS for importing elements into it */
public interface IDSImport
{
 /**
  * Passes an imported element to the import manager.
  *
  * @param element the element or delta element to be applied to the  central repository
  *
  * @exception VersionOutofSyncException if there is a conflict in importing element because of a previous update by
  *                                      another application
  * @exception DirectoryServiceException if there is a problem accessing the underlying storage or the directory does not exist
  *
  */
  public void importedElement(IBasicElement element) throws DirectoryServiceException, VersionOutofSyncException;

}
