/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common;

import java.util.HashMap;

import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
public interface IDSTransaction
{
    public void addCreateElement(IDirElement element);
    public void addCreateElements(IDirElement[] elements);
    public void addUpdateElement(IDeltaDirElement element);
    public void addUpdateElement(IDeltaDirElement element, boolean doNotUpdateIfEmpty);
    public void addDeleteElement(String elementPath);
    public void addCreateFolder(String folderPath);
    public void addCreateFolder(String folderPath, boolean existingOk);
    public void addDeleteFolder(String folderPath);
    public void addRename(String oldPath, String newPath);
    public void addSetAttributes(String path, HashMap attributes);
    public void addSubclassElement(IBasicElement delta, String newElementPath);
    public void addCloneElement(String sourcePath, String newElementPath);
    public void addCloneElement(String sourcePath, String newElementPath, boolean createTemplate);
    public void addCloneElement(IBasicElement deltaFromSource, String newElementPath);
    public void addCloneElement(IBasicElement deltaFromSource, String newElementPath, boolean createTemplate);
    public void addAttachBlob(IBasicElement element, java.io.InputStream blobStream) throws java.io.IOException;
    public void addDetachBlob(IDeltaDirElement delta);
}
