package com.sonicsw.mf.common;

/**
 * This interface represents the behavioral metadata set for a component.
 *
 * A descriptor consists of a collection of fields. Each field is in fieldname=fieldvalue format.
 * Fieldnames are dependent upon the descriptor usage (attribute, operation or notification).
 */
public interface IDescriptor
{
    /**
     * Sets the value for a specific fieldname. The field value will be validated before it is set.
     * If it is not valid, then an exception will be thrown. This will modify an existing field or add a new field.
     *
     * @param fieldName  The field name to be set. Cannot be null or empty.
     * @param fieldValue The field value to be set for the field name. Can be null.
     */
    public void setField(String fieldName, Object fieldValue)
    throws MFRuntimeException;
}
