/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common;

import com.sonicsw.mf.common.config.IElementChangeHandler;

/**
 *  This interface is implemented by administration clients who wish to receive and handle configuration
 *  change notifications.
 */
public interface IDirectoryAdminNotifications
{
    /**
     * Register a configuration change handler to receive changes relating to any configuration
     * stored in the DS.
     *
     * @param handler The handler to be invoked on a change
     *
     * @see #unregisterElementChangeHandler(IElementChangeHandler)
     */
    public void registerElementChangeHandler(IElementChangeHandler handler);

    /**
     * Register a configuration change handler to receive changes relating to the
     * named configuration stored in the DS.
     *
     * @param elementName The element the handler is interested in
     * @param handler     The handler to be invoked on a change
     *
     * @see #unregisterElementChangeHandler(String, IElementChangeHandler)
     */
    public void registerElementChangeHandler(String elementName, IElementChangeHandler handler);

    /**
     * Unregister a previously registered handler that expressed interest in changes to all
     * configuration stored in the DS.
     *
     * @param handler
     */
    public void unregisterElementChangeHandler(IElementChangeHandler handler);

    /**
     * Unregister a previously registered handler that expressed interest in changes to the
     * named configuration stored in the DS.
     *
     * @param elementName The element the handler is interested in
     * @param handler     The handler to be invoked on a change
     */
    public void unregisterElementChangeHandler(String elementName, IElementChangeHandler handler);
}
