package com.sonicsw.mf.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

/**
 * Checked management exception.
 * <p>
 * Classes that extend MFException should be placed in packages that will be available to management applications.
 */
public class MFException
extends Exception
implements Serializable
{
    private static final long serialVersionUID = 8192287077613976467L;
    private static final short m_serialVersion = 0;

    private String m_message;

    /**
     * Constructs a new exception with <code>null</code> as its detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #setLinkedException}.
     */
    public MFException()
    {
        super();
    }

    /**
     * Constructs a new exception with the specified detail message.  The
     * cause is not initialized, and may subsequently be initialized by
     * a call to {@link #setLinkedException}.
     *
     * @param   message   the detail message. The detail message is saved for
     *          later retrieval by the {@link #getMessage()} method.
     */
    public MFException(String message)
    {
        super();
        m_message = message;
    }
    
    

    public MFException(String message, Throwable cause)
    {
        super(message, cause);
        m_message = message;
    }

    /**
     * Returns the detail message string of this throwable.
     *
     * @return  the detail message string of this exception instance
     *          (which may be <tt>null</tt>).
     */
    @Override
    public String getMessage() { return m_message; }

    /**
     * Returns the cause of this throwable or <code>null</code> if the
     * cause is nonexistent or unknown.  (The cause is the exception that
     * caused this exception to get thrown.)
     * <p>
     * As of Sonic 7.6, getLinkedException() will call getCause().
     * 
     * @deprecated Use Throwable.getCause() instead.
     */
    public Exception getLinkedException()
    {
        Throwable cause = super.getCause();
        
        if (cause == null)
        {
            return null;
        }

        if (cause instanceof MFProxyException)
        {
            return (Exception)cause.getCause();
        }

        return (Exception)cause;
    }

    /**
     * Sets the cause of this throwable.  (The cause is the exception that
     * caused this exception to get thrown.)
     * <p>
     * As of Sonic 7.6, setLinkedException() will call initCause(Throwable) with the given
     * exception.
     * 
     * @deprecated Use Throwable.initCause(Throwable) instead.
     */
    public final void setLinkedException(Exception e)
    {
        if (e == null)
        {
            return;
        }

        super.initCause(e instanceof MFException ? e : new MFProxyException(e));
    }

    private void writeObject(ObjectOutputStream stream)
    throws IOException
    {
        // we know how many fields we will write
        stream.writeInt(3);

        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(m_serialVersion));

        stream.writeUTF("message");
        stream.writeObject(m_message);

        stream.writeUTF("linked");
        stream.writeObject(super.getCause());
    }

    private void readObject(ObjectInputStream stream)
    throws IOException, ClassNotFoundException
    {
        // read the number of items and stuff them in a hash map
        int numValues = stream.readInt();
        HashMap map = new HashMap(numValues);
        for (int i = 0; i < numValues; i++)
        {
            map.put(stream.readUTF(), stream.readObject());
        }

        // now map them back into the local variables based on the version
        // Note: As a general rule need to catch exceptions and either do something to set a default
        //       value or ignore

        switch(((Short)map.get("serialVersion")).shortValue())
        {
            // case olderVersion<n> ...
            // case olderVersion<n> ...
            default: // the current version or newer versions
            {
                // MFException fields
                try { m_message = (String)map.get("message"); } catch(Exception e) {}
                try { super.initCause((MFProxyException)map.get("linked")); } catch(Exception e) {}
                break;
            }
        }
    }
}
