package com.sonicsw.mf.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;

public class MFProxyException
extends MFException
{
    private static final long serialVersionUID = 8192287077613976467L;
    private static final short m_serialVersion = 0;

    private String m_actualClass;
    private String m_actualMessage;
    private String m_actualTrace;

    MFProxyException(Exception actualException)
    {
        super(actualException.getMessage(), actualException);

        m_actualClass     = actualException.getClass().getName();
        m_actualTrace     = getActualStackTrace(actualException);
    }

    public final Exception getActualException()
    {
        if (super.getCause() != null)
        {
            return (Exception)super.getCause();
        }
        return this;
    }

    @Override
    public String toString()
    {
        if (super.getCause() != null)
        {
            return super.getCause().toString();
        }

        return (m_actualMessage != null) ? (m_actualClass + ": " + m_actualMessage) : m_actualClass;
    }

    @Override
    public void printStackTrace(PrintStream s)
    {
        if (super.getCause() != null)
        {
            super.getCause().printStackTrace(s);
        }
        else
        {
            s.println(m_actualTrace);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s)
    {
        if (super.getCause() != null)
        {
            super.getCause().printStackTrace(s);
        }
        else
        {
            s.println(m_actualTrace);
        }
    }

    private String getActualStackTrace(Exception e)
    {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out, true);
        e.printStackTrace(writer);
        byte[] data = out.toByteArray();

        try
        {
            out.close();
        }
        catch(IOException io){};

        return new String(data);
    }

    private void writeObject(ObjectOutputStream stream)
    throws IOException
    {
        // we know how many fields we will write
        stream.writeInt(4);

        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(m_serialVersion));

        stream.writeUTF("actualClass");
        stream.writeObject(m_actualClass);

        stream.writeUTF("actualMessage");
        stream.writeObject(m_actualMessage);

        stream.writeUTF("actualTrace");
        stream.writeObject(m_actualTrace);

        // don't serialize the actualException as this may not be available
        // on the client classpath
    }

    private void readObject(ObjectInputStream stream)
    throws IOException, ClassNotFoundException
    {
        // read the number of items and stuff them in a hash map
        int numValues = stream.readInt();
        HashMap map = new HashMap(numValues);
        for (int i = 0; i < numValues; i++)
        {
            map.put(stream.readUTF(), stream.readObject());
        }

        // now map them back into the local variables based on the version
        // Note: As a general rule need to catch exceptions and either do something to set a default
        //       value or ignore

        switch(((Short)map.get("serialVersion")).shortValue())
        {
            // case olderVersion<n> ...
            // case olderVersion<n> ...
            default: // the current version or newer versions
            {
                // MFProxyException fields
                try { m_actualClass = (String)map.get("actualClass"); } catch(Exception e) {}
                try { m_actualMessage = (String)map.get("actualMessage"); } catch(Exception e) {}
                try { m_actualTrace = (String)map.get("actualTrace"); } catch(Exception e) {}
                break;
            }
        }
    }
}