package com.sonicsw.mf.common;

import java.io.Serializable;

/**
 * Thrown when the container of a service (either Agent Manager or Directory) is
 * running, but the service itself is not in the "active" state.  This
 * can occur when a service is in a starting, waiting or stopped state, and
 * will only happen when the service is configured as part of an [MF] fault
 * tolerant pair.  [MF] Fault-tolerant clients should handle this the same
 * as a inaccessible service which causes an invoke timeout exception.
 */
public class MFServiceNotActiveException
extends MFRuntimeException
implements Serializable
{
    private static final long serialVersionUID = 0L;

    public MFServiceNotActiveException(String errorMessage)
    {
        super(errorMessage);
    }
}
