package com.sonicsw.mf.common;

public final class Version
{
    static final short MAJOR_VERSION = 10;
    static final byte MINOR_VERSION = 0;
    static final byte POINT_VERSION = 7;

    static final int BUILD_NUMBER = 129;
    static final int REVISION_NUMBER = 10132;

    static final String PRODUCT_NAME = "Sonic Management 2015";

    static String RELEASE_NAME = MAJOR_VERSION + "." + MINOR_VERSION + '.' + POINT_VERSION;

    public static final Short[] VERSION_INFO = new Short[]
    {
        new Short(MAJOR_VERSION),
        new Short(MINOR_VERSION),
        new Short(POINT_VERSION),
        new Short((short)BUILD_NUMBER)
    };

    // When this class is run standalone it prints its version data to stdout.
    public static void main(String[] args)
    {
        System.out.println("MAJOR_VERSION=" + MAJOR_VERSION);
        System.out.println("MINOR_VERSION=" + MINOR_VERSION + "." + POINT_VERSION);
        System.out.println("BUILD_NUMBER=" + BUILD_NUMBER);
        if (REVISION_NUMBER > 0)
        {
            System.out.println("REVISION=" + REVISION_NUMBER);
        }
    }

    public static String getVersionText()
    {
        return "Release " + RELEASE_NAME + " Build Number " + BUILD_NUMBER;
    }

    public static String getProductName()
    {
        return PRODUCT_NAME;
    }

    public static short getMajorVersion() { return MAJOR_VERSION; }
    public static short getMinorVersion() { return MINOR_VERSION; }
    public static short getPointVersion() { return POINT_VERSION; }
    public static short getBuildNumber() { return (short)BUILD_NUMBER; }
    public static int getRevisionNumber() { return REVISION_NUMBER; }
    public static String getReleaseName() { return RELEASE_NAME; }
}
