/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;

/**
 * This exception is thrown when an attempt is made to violate the type of an IAttributeSet object (e.g.
 * an attempt is made to set an attribute which does not exist for that specific type).
 */
public final class AttributeSetTypeException extends ConfigException
{
    public AttributeSetTypeException (String errorMessage)
    {
        super(errorMessage);
    }

    public AttributeSetTypeException (String attName, String typeName)
    {
        super(attName + " is not an attribute of type '" + typeName + "'");
    }
}
