/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */
package com.sonicsw.mf.common.config;

/**
 * Handles configuration attribute modifications.
 * @see com.sonicsw.mf.common.config.IAttributeSet.registerChangeHandler
 * @see com.sonicsw.mf.common.config.IAttributeList.registerChangeHandler
 */
public interface IAttributeChangeHandler
{

    /**
     * Handles deletion of an attribute set item or an attribute list item. The routine should not throw any Throwable.
     */
    public void itemDeleted();

    /**
     * Handles a modification of an attribute set item or of an attribute list item. The routine should not throw any Throwable.
     *
     * @param value:
     * If this is an IAttributeSet handler: value is IDeltaAttributeSet or IAttributeSet
     * If this is an IAttributeList handler: value is IDeltaAttributeList or IAttributeList
     * If this is basic value handler: value is a new value;
     */
    public void itemModified(Object value);
}
