/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;

/**
 * The type of an IAttributeSet object is the list of attribute names it supports. IAttributeSet objects
 * don't have to be typed, the primary reason for typing is performance - to allow many IAttributeSet
 * objects to share a single definition of attribute names. The IAttributeSetType objects becomes read-only
 * after the first IAttributeSet object of this type is created.
 */
public interface IAttributeSetType
{
 /**
  * Adds a new attribute name to the list of attributes.
  *
  * @param name the name of the new attribute
  *
  * @exception ReadOnlyException if an IAttributeSet object of this type was already created 
  *
  */
  public void addAttributeName(String name) throws ReadOnlyException;

 /**
  * Returns a list of all the attribute names defined for this IAttributeSetType object
  *
  * @return the list of attributes added through the addAttributeName method
  *
  */
  public String[] getAttributeNames();
}
