/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;
import com.sonicsw.mf.common.dirconfig.IDirElement;

public interface IBlob

{
    public static int BLOB_CHUNK_SIZE            = 1000000;
    public static final Integer INCOMPLETE       = new Integer(0);
    public static final Integer COMPLETE         = new Integer(1);
    public static final Integer PARTIAL          = new Integer(0);
    public static final Integer END              = new Integer(1);
    public static final String SYSTEM_ATTRIBUTES  = "_MF_SYSTEM_ATTRIBUTES";
    public static final String BLOB_TRANSFER_STATE = "BLOB_TRANSFER_STATE";
    public static final String LARGE_FILE_STATE   = "LARGE_FILE_STATE";
    public static final String EXPAND_IN_CACHE    = "SONIC_EXPAND_IN_CACHE";
    public static final String ARCHIVE_NAME      =  "ARCHIVE_NAME";
    public static final Boolean EXPANDABLE        = Boolean.TRUE;
    public static final String NON_DSFILE         = "NON_DSFILE";
    public static final String BLOB_ENVELOPE_ELEMENT_IMPORT  = "BLOB_ENVELOPE_ELEMENT_IMPORT";

    /**
     * Returns the element attached to the BLOB.
     *
     * @return the element attached to the BLOB. Null is returned if there no such element.
     */
    public IDirElement getElement();

    /**
     * Returns the stream of bytes that makes the BLOB.
     *
     * @return the stream of bytes that makes the BLOB. Null is returned if there is no attachment.
     */
    public java.io.InputStream getBlobStream();

    /**
     * Gets the underlying bytes that make the BLOB.
     *
     * @return The BLOB bytes.
     */
    public byte[] getBlobBytes();

    /**
     * Sets the flag for whether the element name is a logical name or not
     *
     * @param logical true if the element name is a logical name
     */

    public void setLogical(boolean logical);

    /**
     * Returns the value of the logical namespace flag
     * @return true if the element name of the blob is a logical name
     */

    public boolean isLogicalName();
  }
