package com.sonicsw.mf.common.config;


public interface IChunkedBlobStreamer
{
    /**
    * Retrieves a piece of the blob, starting at byte offset, and of length IBlob.BLOB_CHUNK_SIZE or
    * the entire length of the blob if its size is < IBlob.BLOB_CHUNK_SIZE. The blob element is marked
    * as PARTIAL if the blob piece is not the end piece, or END if it is. This method is invoked by the
    * DirectoryServiceProxy and is not part of the public interface. If the blob for elementName is
    * still being saved to disk (state == INCOMPLETE) then the blob will be null.
    *
    * @param elementName the name of the blob (the full path)
    * @param forUpdate true if the element should be writable
    * @param offset the starting index in the stream
    * @return the blob object with the element and the partial blob (full blob if it's size is < IBlob.BLOB_CHUNK_SIZE
    *
    * @exception Exception the exception thrown depends on the object; a Proxy will throw a DirectoryServiceException
    * but the container cache will throw a PersistentCacheException
    *
    */

    public IBlob getBlob(String elementName, boolean forUpdate, int offset) throws Exception;

    /**
    * Retrieves a piece of the blob, starting at byte offset, and of length IBlob.BLOB_CHUNK_SIZE or
    * the entire length of the blob if its size is < IBlob.BLOB_CHUNK_SIZE. The blob element is marked
    * as PARTIAL if the blob piece is not the end piece, or END if it is. This method is invoked by the
    * DirectoryServiceProxy and is not part of the public interface. If the blob for elementName is
    * still being saved to disk (state == INCOMPLETE) the byte array for the returned IBlob will be null.
    *
    * @param elementName the name of the blob (the full path) in the logical storage namespace
    * @param forUpdate true if the element should be writable
    * @param offset the starting index in the stream
    * @return the blob object with the element and the partial blob (full blob if it's size is < IBlob.BLOB_CHUNK_SIZE
    *
    * @exception Exception, depending on the implementation. The Proxy and DS objects will throw DirectoryServiceException
    * but the container cache will throw a PersistentCacheException
    *
    */
    public IBlob getFSBlob(String elementName, boolean forUpdate, int offset) throws Exception;
}