/*
 * Copyright (c) 2001 Sonic Software. All Rights Reserved.
 */

package com.sonicsw.mf.common.config;
import java.util.ArrayList;
import java.util.HashMap;

import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.view.INamingListener;

// Handlers must implement this interface, typically by extending AbstractDSHandler
/* Handler Registration Example:
      <Directory name="/_MFLibrary/ds_handlers">
        <ConfigElement>
          <ElementID type="MF_DS_HANDLER" creationTimestamp="1086188014013" releaseVersion="100" name="/_MFLibrary/ds_handlers/test_
handler" version="1" />
          <AttributeSet>
            <Attribute value="qa.mgmt.mf.directory.DSHandler" type="string" name="DS_HANDLER_CLASS" />
            <Attribute value="/_MFContext/SonicESB" type="string" name="DS_HANDLER_NAME" />
            <AttributeList>
              <AttributeName name="DS_HANDLER_ARCHIVES" />
              <ListItem value="sonicfs:///ESB/5.5/ds_handler.jar" type="string" />
            </AttributeList>
          </AttributeSet>
        </ConfigElement>
      </Directory>
    </Directory>
*/
public interface IDSHandler
{

    public void setDSContext(IDSHandlerContext dsContext) throws DirectoryServiceException;

    public void setHandlerName(String name);

    public IDirElement getElement(String elementName) throws DirectoryServiceException;

    public IDirElement[] getAllElements(String dirName) throws DirectoryServiceException;

    public IElementIdentity[] listElements(String dirName) throws DirectoryServiceException;

    public IDirIdentity[] listDirectories(String dirName) throws DirectoryServiceException;

    public IIdentity[] listAll(String dirName) throws DirectoryServiceException;

    public void rename(String oldName, String newName)  throws DirectoryServiceException;

    public void createFolder(String folderPath, boolean existingOk) throws DirectoryServiceException;

    public void createFolder(String folderPath) throws DirectoryServiceException;

    public void deleteFolder(String folderPath) throws DirectoryServiceException;

    public HashMap[] listFolders(String folderPath) throws DirectoryServiceException;

    public HashMap[] listFSAll(String path) throws DirectoryServiceException;

    public ArrayList listFSAll(String path, boolean listFolders, boolean listElements, String extension) throws DirectoryServiceException;

    public HashMap[] listFSElements(String folderPath) throws DirectoryServiceException;

    public void setMetaAttributes(String path, HashMap attributes) throws DirectoryServiceException;

    public HashMap getMetaAttributes(String path) throws DirectoryServiceException;

    public IDirElement getFSElement(String elementPath, boolean forUpdate) throws DirectoryServiceException;

    public IDirElement[] getFSElements(String folderPath, boolean forUpdate) throws DirectoryServiceException;

    public IDirElement getFSElement(String elementPath, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException;

    public IElementIdentity getFSIdentity (String elementPath) throws DirectoryServiceException;

    public IElementIdentity deleteFSElement(String elementPath) throws DirectoryServiceException, VersionOutofSyncException;

    public INextVersionToken createFSElement(IDirElement element) throws DirectoryServiceException, VersionOutofSyncException;

    public INextVersionToken updateFSElement(IDeltaDirElement element) throws DirectoryServiceException, VersionOutofSyncException;

    public void attachFSBlob(IBasicElement element, java.io.InputStream blobStream) throws DirectoryServiceException,VersionOutofSyncException;

    public void attachFSBlob(IBasicElement element, byte[] blob) throws DirectoryServiceException, VersionOutofSyncException;

    public IBlob getBlobByLogicalName(String logicalName) throws DirectoryServiceException;
    public IBlob getFSBlob(String elementPath, boolean forUpdate) throws DirectoryServiceException;

    public IBlob getFSBlob(String elementPath, boolean forUpdate, int offset) throws DirectoryServiceException;

    public void detachFSBlob(IDeltaDirElement delta) throws DirectoryServiceException, VersionOutofSyncException;

    public void appendFSBlob(IBasicElement element, byte[]blob, int offset, boolean last) throws DirectoryServiceException;
    
    public void subscribe(INamingListener listener);
    
    public void doNotify();
}



